/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class AppDetailView
extends Canvas {
    private static final int HEADER_HEIGHT = 30;
    private static final int PADDING = 10;
    private static final int BUTTON_HEIGHT = 40;
    private static final int VOTE_BUTTON_WIDTH = 70;
    private static final int COLOR_BACKGROUND = 0xF0F0F0;
    private static final int COLOR_HEADER = 15480656;
    private static final int COLOR_TEXT = 2899536;
    private static final int COLOR_HIGHLIGHT = 15220566;
    private static final int COLOR_WHITE = 0xFFFFFF;
    private static final int COLOR_LIGHT_GRAY = 0xD3D3D3;
    private static final int COLOR_GRAY = 8359053;
    private static final int COLOR_UPVOTE = 2600544;
    private static final int COLOR_DOWNVOTE = 12597547;
    private int width;
    private int height;
    private int contentHeight;
    private int scrollPosition = 0;
    private static final int MAX_SCROLL_SPEED = 20;
    private boolean isLoading = false;
    private boolean moreDetailsLoaded = false;
    private boolean isVoting = false;
    private String additionalDescription = null;
    private String version = null;
    private String size = null;
    private String developer = null;
    private String category = null;
    private int votes = 0;
    private MIDletStore midletStore;
    private MIDletStore.MidletInfo app;
    private Image appIcon;
    private CommandListener commandListener;
    private Command backCommand;
    private Command installCommand;
    private Command upvoteCommand;
    private Command downvoteCommand;
    private int lastPointerY = 0;

    public AppDetailView(MIDletStore mIDletStore, MIDletStore.MidletInfo midletInfo, Image image) {
        this.midletStore = mIDletStore;
        this.app = midletInfo;
        this.appIcon = image;
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.backCommand = new Command("Back", 2, 1);
        this.installCommand = new Command("Install", 8, 1);
        this.upvoteCommand = new Command("Upvote", 8, 2);
        this.downvoteCommand = new Command("Downvote", 8, 3);
        this.addCommand(this.backCommand);
        this.addCommand(this.installCommand);
        this.addCommand(this.upvoteCommand);
        this.addCommand(this.downvoteCommand);
        this.votes = midletInfo.getVotes();
        this.fetchAppDetails();
    }

    public void setCommandListener(CommandListener commandListener) {
        super.setCommandListener(commandListener);
        this.commandListener = commandListener;
    }

    private void fetchAppDetails() {
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                AppDetailView.this.isLoading = true;
                AppDetailView.this.repaint();
                HttpConnection httpConnection = null;
                InputStream inputStream = null;
                try {
                    String string;
                    String string2 = AppDetailView.this.app.getId();
                    String string3 = "http://localhost:3000/storeapi/apps/" + string2;
                    if (AppDetailView.this.midletStore != null && (string = AppDetailView.this.midletStore.getDeviceQueryString()) != null && string.length() > 0) {
                        string3 = string3 + (string3.indexOf(63) >= 0 ? "&" : "?") + string;
                    }
                    if ((httpConnection = (HttpConnection)Connector.open((String)string3)).getResponseCode() == 200) {
                        inputStream = httpConnection.openInputStream();
                        AppDetailView.this.parseAppDetails(inputStream);
                        AppDetailView.this.moreDetailsLoaded = true;
                    }
                }
                catch (Exception exception) {
                    System.out.println("Error fetching app details: " + exception.toString());
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (httpConnection != null) {
                            httpConnection.close();
                        }
                    }
                    catch (IOException iOException) {}
                    AppDetailView.this.isLoading = false;
                    AppDetailView.this.repaint();
                }
            }
        };
        thread.start();
    }

    private void parseAppDetails(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        String string = new String(byteArrayOutputStream.toByteArray());
        String[] stringArray = this.split(string, "\n");
        if (stringArray.length >= 2) {
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            String[] stringArray2 = this.split(string2, ",");
            String[] stringArray3 = this.split(string3, ",");
            for (int i = 0; i < stringArray2.length && i < stringArray3.length; ++i) {
                String string4 = stringArray2[i].trim();
                String string5 = stringArray3[i].trim();
                if (string4.equals("description")) {
                    this.additionalDescription = string5;
                    continue;
                }
                if (string4.equals("version")) {
                    this.version = string5;
                    continue;
                }
                if (string4.equals("size")) {
                    this.size = string5 + " KB";
                    continue;
                }
                if (string4.equals("developer")) {
                    this.developer = string5;
                    continue;
                }
                if (string4.equals("category")) {
                    this.category = string5;
                    continue;
                }
                if (!string4.equals("votes")) continue;
                try {
                    this.votes = Integer.parseInt(string5);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    this.votes = 0;
                }
            }
        }
        this.repaint();
    }

    private String[] splitCSV(String string) {
        int n;
        Vector<String> vector = new Vector<String>();
        if (string == null || string.length() == 0) {
            String[] stringArray = new String[]{""};
            return stringArray;
        }
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            if (n == 34) {
                bl = !bl;
                continue;
            }
            if (n == 44 && !bl) {
                vector.addElement(stringBuffer.toString().trim());
                stringBuffer = new StringBuffer();
                continue;
            }
            stringBuffer.append((char)n);
        }
        vector.addElement(stringBuffer.toString().trim());
        String[] stringArray = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            stringArray[n] = (String)vector.elementAt(n);
        }
        return stringArray;
    }

    protected void paint(Graphics graphics) {
        this.width = this.getWidth();
        this.height = this.getHeight();
        graphics.setColor(0xF0F0F0);
        graphics.fillRect(0, 0, this.width, this.height);
        this.drawAppDetails(graphics);
    }

    private void drawVotes(Graphics graphics, int n, int n2, int n3) {
        String string = (n > 0 ? "+" : "") + String.valueOf(n);
        int n4 = 12;
        int n5 = graphics.getFont().stringWidth(string);
        int n6 = n4 + 4 + n5;
        if (n > 0) {
            graphics.setColor(2600544);
            int[] nArray = new int[]{n2 + n4 / 2, n2 + n4, n2};
            int[] nArray2 = new int[]{n3, n3 + n4, n3 + n4};
            graphics.fillTriangle(nArray[0], nArray2[0], nArray[1], nArray2[1], nArray[2], nArray2[2]);
        } else if (n < 0) {
            graphics.setColor(12597547);
            int[] nArray = new int[]{n2, n2 + n4, n2 + n4 / 2};
            int[] nArray3 = new int[]{n3, n3, n3 + n4};
            graphics.fillTriangle(nArray[0], nArray3[0], nArray[1], nArray3[1], nArray[2], nArray3[2]);
        } else {
            graphics.setColor(8359053);
            graphics.drawRect(n2, n3, n4, n4);
        }
        graphics.drawString(string, n2 + n4 + 4, n3, 20);
    }

    private void drawAppDetails(Graphics graphics) {
        graphics.setColor(15480656);
        graphics.fillRect(0, 0, this.width, 30);
        graphics.setColor(0xFFFFFF);
        graphics.setFont(Font.getFont((int)0, (int)1, (int)0));
        this.drawText(graphics, this.app.getName(), this.width / 2, 15, true);
        graphics.setColor(0xFFFFFF);
        graphics.fillTriangle(10, 15, 18, 7, 18, 23);
        this.drawText(graphics, "Back", 30, 15, false);
        graphics.translate(0, -this.scrollPosition);
        int n = 40;
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, n, this.width, 120);
        if (this.appIcon != null) {
            graphics.drawImage(this.appIcon, 10, n + 10, 20);
        }
        int n2 = 68;
        graphics.setColor(2899536);
        graphics.setFont(Font.getFont((int)0, (int)1, (int)0));
        graphics.drawString(this.app.getName(), n2, n + 10, 20);
        graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
        graphics.setColor(8359053);
        graphics.drawString(this.developer != null ? this.developer : "Unknown Developer", n2, n + 30, 20);
        this.drawVotes(graphics, this.votes, n2, n + 45);
        graphics.setColor(15220566);
        graphics.fillRoundRect(this.width - 85 - 10, n + 10, 70, 40, 10, 10);
        graphics.setColor(0xFFFFFF);
        graphics.setFont(Font.getFont((int)0, (int)1, (int)0));
        this.drawText(graphics, "GET", this.width - 50 - 10, n + 30, true);
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, n += 80, this.width, 120);
        graphics.setColor(2899536);
        graphics.setFont(Font.getFont((int)0, (int)1, (int)0));
        graphics.drawString("Information", 10, n + 10, 20);
        int n3 = 10;
        int n4 = this.width / 2 + 10;
        int n5 = n + 40;
        graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
        graphics.drawString("Developer", n3, n5, 20);
        graphics.drawString("Category", n3, n5 + 20, 20);
        graphics.drawString(this.developer != null ? this.developer : "Unknown", n4, n5, 20);
        graphics.drawString(this.category != null ? this.category : "Utilities", n4, n5 + 20, 20);
        graphics.drawString("Size", n3, n5 += 40, 20);
        graphics.drawString("Version", n3, n5 + 20, 20);
        graphics.drawString("Compatibility", n3, n5 + 40, 20);
        graphics.drawString("Votes", n3, n5 + 60, 20);
        graphics.drawString(this.size != null ? this.size : "Unknown", n4, n5, 20);
        graphics.drawString(this.version != null ? this.version : "1.0", n4, n5 + 20, 20);
        String string = this.app.getSupportedStatus();
        if (string == null) {
            string = "Unknown";
        }
        if (string.equals("fully_supported")) {
            graphics.setColor(43520);
            graphics.drawString("Fully Supported", n4, n5 + 40, 20);
        } else if (string.equals("partially_supported")) {
            graphics.setColor(0xFFAA00);
            graphics.drawString("Partially Supported", n4, n5 + 40, 20);
        } else if (string.equals("not_supported")) {
            graphics.setColor(0xAA0000);
            graphics.drawString("Not Supported", n4, n5 + 40, 20);
        } else {
            graphics.setColor(8359053);
            graphics.drawString(string, n4, n5 + 40, 20);
        }
        if (this.votes > 0) {
            graphics.setColor(2600544);
            graphics.drawString("+" + this.votes, n4, n5 + 60, 20);
        } else if (this.votes < 0) {
            graphics.setColor(12597547);
            graphics.drawString(String.valueOf(this.votes), n4, n5 + 60, 20);
        } else {
            graphics.setColor(8359053);
            graphics.drawString("0", n4, n5 + 60, 20);
        }
        graphics.setColor(2899536);
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, n += 180, this.width, 200);
        graphics.setColor(2899536);
        graphics.setFont(Font.getFont((int)0, (int)1, (int)0));
        graphics.drawString("Description", 10, n + 10, 20);
        String string2 = this.app.getDescription();
        graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
        int n6 = n + 40;
        n6 = this.drawWrappedText(graphics, string2, 10, n6, this.width - 20);
        n = n6 + 10;
        graphics.setColor(15220566);
        graphics.fillRoundRect(10, n, this.width - 20, 40, 10, 10);
        graphics.setColor(0xFFFFFF);
        graphics.setFont(Font.getFont((int)0, (int)1, (int)0));
        this.drawText(graphics, "INSTALL", this.width / 2, n + 20, true);
        this.contentHeight = (n += 70) - 30;
        graphics.translate(0, this.scrollPosition);
        if (this.contentHeight > this.height - 30) {
            int n7;
            int n8;
            if (this.scrollPosition > 0) {
                graphics.setColor(8359053);
                n8 = this.width / 2;
                n7 = 40;
                graphics.fillTriangle(n8, n7, n8 - 10, n7 + 10, n8 + 10, n7 + 10);
            }
            if (this.scrollPosition < this.contentHeight - (this.height - 30)) {
                graphics.setColor(8359053);
                n8 = this.width / 2;
                n7 = this.height - 10;
                graphics.fillTriangle(n8, n7, n8 - 10, n7 - 10, n8 + 10, n7 - 10);
            }
        }
        if (this.isLoading || this.isVoting) {
            graphics.setColor(Integer.MIN_VALUE);
            graphics.fillRect(0, 30, this.width, this.height - 30);
            graphics.setColor(0xFFFFFF);
            graphics.setFont(Font.getFont((int)0, (int)1, (int)0));
            this.drawText(graphics, this.isVoting ? "Submitting vote..." : "Loading...", this.width / 2, this.height / 2, true);
        }
    }

    private int drawWrappedText(Graphics graphics, String string, int n, int n2, int n3) {
        String string2;
        int n4;
        if (string == null || string.length() == 0) {
            return n2;
        }
        Font font = graphics.getFont();
        int n5 = font.getHeight();
        Vector<String> vector = new Vector<String>();
        String[] stringArray = this.split(string, "\n");
        for (n4 = 0; n4 < stringArray.length; ++n4) {
            string2 = stringArray[n4];
            String[] stringArray2 = this.split(string2, " ");
            String string3 = "";
            for (int i = 0; i < stringArray2.length; ++i) {
                String string4;
                String string5 = string4 = string3.length() > 0 ? string3 + " " + stringArray2[i] : stringArray2[i];
                if (font.stringWidth(string4) <= n3) {
                    string3 = string4;
                    continue;
                }
                vector.addElement(string3);
                string3 = stringArray2[i];
            }
            if (string3.length() > 0) {
                vector.addElement(string3);
            }
            if (n4 >= stringArray.length - 1) continue;
            vector.addElement("");
        }
        for (n4 = 0; n4 < vector.size(); ++n4) {
            string2 = (String)vector.elementAt(n4);
            graphics.drawString(string2, n, n2, 20);
            n2 += n5;
        }
        return n2;
    }

    private void drawText(Graphics graphics, String string, int n, int n2, boolean bl) {
        int n3;
        if (bl) {
            n3 = graphics.getFont().stringWidth(string);
            n -= n3 / 2;
        }
        n3 = graphics.getFont().getHeight();
        graphics.drawString(string, n, n2 -= n3 / 2, 20);
    }

    private String[] split(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        if (string == null || string.length() == 0) {
            String[] stringArray = new String[]{""};
            return stringArray;
        }
        int n = 0;
        int n2 = string.indexOf(string2);
        while (n2 >= 0) {
            vector.addElement(string.substring(n, n2));
            n = n2 + string2.length();
            n2 = string.indexOf(string2, n);
        }
        if (n <= string.length()) {
            vector.addElement(string.substring(n));
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    protected void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        if (n2 == 1) {
            this.scrollPosition = Math.max(0, this.scrollPosition - 20);
            this.repaint();
        } else if (n2 == 6) {
            int n3 = Math.max(0, this.contentHeight - (this.height - 30));
            this.scrollPosition = Math.min(n3, this.scrollPosition + 20);
            this.repaint();
        } else if (n2 == 8) {
            this.midletStore.installMidlet(this.app);
        } else if ((n2 == 2 || n == 48) && this.commandListener != null) {
            this.commandListener.commandAction(this.backCommand, (Displayable)this);
        }
    }

    protected void pointerPressed(int n, int n2) {
        int n3 = 110;
        int n4 = this.height - 40 - 30;
        if (n2 >= n4 && n2 <= n4 + 40 && n >= 10 && n <= this.width - 10) {
            this.midletStore.installMidlet(this.app);
            return;
        }
        this.lastPointerY = n2;
    }

    protected int getLastPointerY() {
        return this.lastPointerY;
    }

    protected void pointerDragged(int n, int n2) {
        if (n2 != this.getLastPointerY()) {
            int n3;
            int n4 = this.getLastPointerY() - n2;
            if (n4 > 20) {
                n4 = 20;
            }
            if (n4 < -20) {
                n4 = -20;
            }
            this.scrollPosition += n4;
            if (this.scrollPosition < 0) {
                this.scrollPosition = 0;
            }
            if (this.scrollPosition > (n3 = Math.max(0, this.contentHeight - (this.height - 30)))) {
                this.scrollPosition = n3;
            }
            this.repaint();
        }
    }

    public MIDletStore.MidletInfo getAppInfo() {
        return this.app;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.backCommand) {
            if (this.commandListener != null) {
                this.commandListener.commandAction(this.backCommand, (Displayable)this);
            }
        } else if (command == this.installCommand) {
            this.midletStore.installMidlet(this.app);
        } else if (command == this.upvoteCommand) {
            this.submitVote(true);
        } else if (command == this.downvoteCommand) {
            this.submitVote(false);
        }
    }

    private void submitVote(final boolean bl) {
        if (this.isVoting) {
            return;
        }
        this.isVoting = true;
        this.repaint();
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HttpConnection httpConnection = null;
                InputStream inputStream = null;
                try {
                    String string;
                    String string2 = AppDetailView.this.app.getId();
                    String string3 = "http://localhost:3000/storeapi/vote?appId=" + string2 + "&voteType=" + (bl ? "upvote" : "downvote");
                    if (AppDetailView.this.midletStore != null && (string = AppDetailView.this.midletStore.getDeviceQueryString()) != null && string.length() > 0) {
                        string3 = string3 + "&" + string;
                    }
                    httpConnection = (HttpConnection)Connector.open((String)string3);
                    httpConnection.setRequestMethod("POST");
                    httpConnection.setRequestProperty("User-Agent", "MIDletStore/1.0");
                    int n = httpConnection.getResponseCode();
                    if (n == 200) {
                        inputStream = httpConnection.openInputStream();
                        String string4 = AppDetailView.this.readResponse(inputStream);
                        int n2 = AppDetailView.this.parseVoteResponse(string4);
                        AppDetailView.this.votes = n2;
                        AppDetailView.this.app.setVotes(n2);
                        AppDetailView.this.showVoteConfirmation(bl);
                    } else {
                        AppDetailView.this.showAlert("Vote Failed", "Could not submit vote (HTTP " + n + ")", AlertType.ERROR);
                    }
                }
                catch (Exception exception) {
                    AppDetailView.this.showAlert("Vote Error", "Error: " + exception.getMessage(), AlertType.ERROR);
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (httpConnection != null) {
                            httpConnection.close();
                        }
                    }
                    catch (IOException iOException) {}
                    AppDetailView.this.isVoting = false;
                    AppDetailView.this.repaint();
                }
            }
        };
        thread.start();
    }

    private int parseVoteResponse(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            System.out.println("Error parsing vote response: " + exception.toString());
            return this.votes;
        }
    }

    private String readResponse(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return new String(byteArrayOutputStream.toByteArray());
    }

    private void showVoteConfirmation(boolean bl) {
        String string = bl ? "Upvoted!" : "Downvoted!";
        String string2 = bl ? "You gave " + this.app.getName() + " an upvote. New score: " + this.votes : "You gave " + this.app.getName() + " a downvote. New score: " + this.votes;
        AlertType alertType = bl ? AlertType.INFO : AlertType.WARNING;
        this.showAlert(string, string2, alertType);
    }

    private void showAlert(String string, String string2, AlertType alertType) {
        Alert alert = new Alert(string, string2, null, alertType);
        alert.setTimeout(2000);
        Display.getDisplay((MIDlet)this.midletStore).setCurrent(alert, (Displayable)this);
    }
}

