/*
 * Decompiled with CFR 0.152.
 */
import com.sun.svg.component.LoadingScreen;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.m2g.SVGAnimator;
import javax.microedition.m2g.SVGImage;
import javax.microedition.midlet.MIDlet;

public class MIDletStore
extends MIDlet
implements CommandListener {
    private Display display;
    private StoreCanvas storeCanvas;
    private Vector midletsList;
    private Vector featuredApps;
    private Command exitCommand;
    private Command selectCommand;
    private Command backCommand;
    private boolean isLoading;
    private String csvUrl = "http://localhost:3000/storeapi";
    private static final String CLIENT_VERSION = "1.0";
    private AppDetailView appDetailView;
    private String deviceId = null;
    private String supportedAPIs = null;
    private SearchPage searchPage;
    private Vector appIcons;
    private TopChartsPage topChartsPage;

    public void startApp() {
        this.display = Display.getDisplay((MIDlet)this);
        if (this.storeCanvas == null) {
            this.initDeviceInfo();
            this.appIcons = new Vector();
            this.exitCommand = new Command("Exit", 7, 1);
            this.selectCommand = new Command("Select", 8, 1);
            this.backCommand = new Command("Back", 2, 1);
            this.showLoadingScreen();
            this.checkVersion();
        } else {
            this.display.setCurrent((Displayable)this.storeCanvas);
        }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCommand) {
            this.destroyApp(true);
            this.notifyDestroyed();
        } else if (command == this.selectCommand && displayable == this.storeCanvas) {
            MidletInfo midletInfo = this.storeCanvas.getSelectedMidlet();
            if (midletInfo != null) {
                this.showAppDetails(midletInfo, null);
            }
        } else if (command == this.backCommand || command.getCommandType() == 2 && displayable instanceof AppDetailView) {
            this.display.setCurrent((Displayable)this.storeCanvas);
        } else if (command.getCommandType() == 8 && displayable instanceof AppDetailView) {
            AppDetailView appDetailView = (AppDetailView)displayable;
            if (command.getLabel().equals("Install")) {
                MidletInfo midletInfo = appDetailView.getAppInfo();
                if (midletInfo != null) {
                    this.installMidlet(midletInfo);
                }
            } else if (command.getLabel().equals("Upvote")) {
                appDetailView.commandAction(command, displayable);
            } else if (command.getLabel().equals("Downvote")) {
                appDetailView.commandAction(command, displayable);
            }
        } else if (command.getCommandType() == 8 && command.getLabel().equals("Search") && displayable == this.storeCanvas) {
            this.showSearchPage();
        } else if (command.getCommandType() == 8 && command.getLabel().equals("Top Charts") && displayable == this.storeCanvas) {
            this.showTopChartsPage();
        }
    }

    private void checkVersion() {
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HttpConnection httpConnection = null;
                InputStream inputStream = null;
                try {
                    String string = MIDletStore.this.csvUrl + "/version";
                    httpConnection = (HttpConnection)Connector.open((String)string);
                    httpConnection.setRequestProperty("User-Agent", "MIDletStore/1.0");
                    int n = httpConnection.getResponseCode();
                    if (n == 200) {
                        inputStream = httpConnection.openInputStream();
                        String string2 = MIDletStore.this.readResponseAsString(inputStream);
                        if (MIDletStore.this.isNewVersionAvailable(MIDletStore.CLIENT_VERSION, string2)) {
                            MIDletStore.this.promptForUpgrade(string2);
                        } else {
                            MIDletStore.this.loadMidletsFromCSV();
                        }
                    } else {
                        System.out.println("Error checking version: HTTP " + n);
                        MIDletStore.this.loadMidletsFromCSV();
                    }
                }
                catch (IOException iOException) {
                    System.out.println("Error checking version: " + iOException.getMessage());
                    MIDletStore.this.loadMidletsFromCSV();
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (httpConnection != null) {
                            httpConnection.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        thread.start();
    }

    private boolean isNewVersionAvailable(String string, String string2) {
        try {
            int[] nArray = this.parseVersionParts(string);
            int[] nArray2 = this.parseVersionParts(string2);
            if (nArray2[0] > nArray[0]) {
                return true;
            }
            if (nArray2[0] == nArray[0]) {
                return nArray2[1] > nArray[1];
            }
            return false;
        }
        catch (Exception exception) {
            System.out.println("Error parsing version: " + exception.getMessage());
            return false;
        }
    }

    private int[] parseVersionParts(String string) {
        int[] nArray = new int[]{0, 0};
        if (string != null && string.length() > 0) {
            int n = string.indexOf(46);
            if (n > 0 && n < string.length() - 1) {
                try {
                    nArray[0] = Integer.parseInt(string.substring(0, n));
                    nArray[1] = Integer.parseInt(string.substring(n + 1));
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                try {
                    nArray[0] = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return nArray;
    }

    private void promptForUpgrade(final String string) {
        final Command command = new Command("Upgrade", 4, 1);
        Command command2 = new Command("Skip", 3, 2);
        Alert alert = new Alert("Update Available", "A new version (" + string + ") of the MIDlet Store is available. " + "Would you like to upgrade now?", null, AlertType.INFO);
        alert.addCommand(command);
        alert.addCommand(command2);
        alert.setTimeout(-2);
        alert.setCommandListener(new CommandListener(){

            public void commandAction(Command command2, Displayable displayable) {
                block5: {
                    if (command2 == command) {
                        try {
                            String string2 = MIDletStore.this.csvUrl + "/download?version=" + MIDletStore.this.encode(string);
                            if (MIDletStore.this.platformRequest(string2)) {
                                MIDletStore.this.destroyApp(false);
                                MIDletStore.this.notifyDestroyed();
                                break block5;
                            }
                            MIDletStore.this.loadMidletsFromCSV();
                        }
                        catch (Exception exception) {
                            Alert alert = new Alert("Error", "Failed to start upgrade: " + exception.getMessage(), null, AlertType.ERROR);
                            alert.setTimeout(2000);
                            MIDletStore.this.display.setCurrent((Displayable)alert);
                            MIDletStore.this.loadMidletsFromCSV();
                        }
                    } else {
                        MIDletStore.this.loadMidletsFromCSV();
                    }
                }
            }
        });
        this.display.setCurrent((Displayable)alert);
    }

    private String readResponseAsString(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toString().trim();
    }

    private void initDeviceInfo() {
        this.deviceId = this.getSystemProperty("com.nokia.mid.imei");
        if (this.deviceId == null || this.deviceId.length() == 0) {
            this.deviceId = this.getSystemProperty("com.sonyericsson.imei");
        }
        if (this.deviceId == null || this.deviceId.length() == 0) {
            this.deviceId = this.getSystemProperty("phone.imei");
        }
        if (this.deviceId == null || this.deviceId.length() == 0) {
            this.deviceId = this.getSystemProperty("com.motorola.IMEI");
        }
        if (this.deviceId == null || this.deviceId.length() == 0) {
            this.deviceId = this.getSystemProperty("device.id");
        }
        if (this.deviceId == null || this.deviceId.length() == 0) {
            this.deviceId = this.getSystemProperty("microedition.platform");
        }
        if (this.deviceId == null || this.deviceId.length() == 0) {
            this.deviceId = "unknown";
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.checkJSR(stringBuffer, "JSR30", "javax.microedition.io.file.FileConnection");
        this.checkJSR(stringBuffer, "JSR75", "javax.microedition.io.file.FileConnection");
        this.checkJSR(stringBuffer, "JSR82", "javax.bluetooth.LocalDevice");
        this.checkJSR(stringBuffer, "JSR118", "javax.microedition.midlet.MIDlet");
        this.checkJSR(stringBuffer, "JSR120", "javax.wireless.messaging.Message");
        this.checkJSR(stringBuffer, "JSR135", "javax.microedition.media.Player");
        this.checkJSR(stringBuffer, "JSR172", "javax.xml.parsers.SAXParser");
        this.checkJSR(stringBuffer, "JSR177", "javax.microedition.securityservice.CMSMessageSignatureService");
        this.checkJSR(stringBuffer, "JSR179", "javax.microedition.location.Location");
        this.checkJSR(stringBuffer, "JSR180", "javax.microedition.sip.SipConnection");
        this.checkJSR(stringBuffer, "JSR184", "javax.microedition.m3g.Graphics3D");
        this.checkJSR(stringBuffer, "JSR205", "javax.wireless.messaging.MessageConnection");
        this.checkJSR(stringBuffer, "JSR211", "javax.microedition.content.Invocation");
        this.checkJSR(stringBuffer, "JSR226", "javax.microedition.m2g.SVGImage");
        this.checkJSR(stringBuffer, "JSR234", "javax.microedition.amms.control.audioeffect.EqualizerControl");
        this.checkJSR(stringBuffer, "JSR238", "javax.microedition.global.Formatter");
        this.checkJSR(stringBuffer, "JSR239", "javax.microedition.khronos.egl.EGL");
        this.checkJSR(stringBuffer, "JSR256", "javax.microedition.sensor.SensorConnection");
        this.checkJSR(stringBuffer, "JSR280", "javax.microedition.contactless.ContactlessException");
        this.checkJSR(stringBuffer, "JSR281", "javax.microedition.contactless.ndef.NDEFMessage");
        this.checkJSR(stringBuffer, "JSR293", "javax.microedition.location.LandmarkStore");
        this.supportedAPIs = stringBuffer.toString();
        this.supportedAPIs = this.supportedAPIs.length() > 0 ? this.supportedAPIs.substring(0, this.supportedAPIs.length() - 1) : "none";
        System.out.println("Device ID: " + this.deviceId);
        System.out.println("Supported APIs: " + this.supportedAPIs);
    }

    private void checkJSR(StringBuffer stringBuffer, String string, String string2) {
        try {
            Class.forName(string2);
            stringBuffer.append(string).append(",");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getSystemProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            return "";
        }
    }

    public String getDeviceQueryString() {
        if (this.deviceId != null && this.supportedAPIs != null) {
            return "device=" + this.encode(this.deviceId) + "&jsrs=" + this.encode(this.supportedAPIs);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showLoadingScreen() {
        this.isLoading = true;
        try {
            SVGImage sVGImage;
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/loading.svg");
            if (inputStream == null) {
                this.destroyApp(false);
                this.notifyDestroyed();
                return;
            }
            try {
                try {
                    sVGImage = (SVGImage)SVGImage.createImage((InputStream)inputStream, null);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException iOException) {
                this.destroyApp(false);
                this.notifyDestroyed();
                return;
            }
            if (inputStream != null) {
                SVGAnimator sVGAnimator = SVGAnimator.createAnimator((SVGImage)sVGImage);
                Displayable displayable = (Displayable)sVGAnimator.getTargetComponent();
                this.display.setCurrent(displayable);
                sVGAnimator.play();
                inputStream.close();
            } else {
                LoadingScreen loadingScreen = new LoadingScreen("Hack MIDlet Store", "Loading Applications...");
                this.display.setCurrent((Displayable)loadingScreen);
            }
        }
        catch (IOException iOException) {
            LoadingScreen loadingScreen = new LoadingScreen();
            this.display.setCurrent((Displayable)loadingScreen);
        }
    }

    private void loadMidletsFromCSV() {
        this.midletsList = new Vector();
        this.featuredApps = new Vector();
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HttpConnection httpConnection = null;
                InputStream inputStream = null;
                try {
                    String string = MIDletStore.this.csvUrl + "/register";
                    string = string.indexOf(63) >= 0 ? string + "&device=" + MIDletStore.this.encode(MIDletStore.this.deviceId) + "&jsrs=" + MIDletStore.this.encode(MIDletStore.this.supportedAPIs) : string + "?device=" + MIDletStore.this.encode(MIDletStore.this.deviceId) + "&jsrs=" + MIDletStore.this.encode(MIDletStore.this.supportedAPIs);
                    String string2 = MIDletStore.this.csvUrl + "/apps";
                    string2 = string2.indexOf(63) >= 0 ? string2 + "&device=" + MIDletStore.this.encode(MIDletStore.this.deviceId) : string2 + "?device=" + MIDletStore.this.encode(MIDletStore.this.deviceId);
                    httpConnection = (HttpConnection)Connector.open((String)string);
                    if (httpConnection.getResponseCode() == 200) {
                        inputStream = httpConnection.openInputStream();
                    } else {
                        MIDletStore.this.handleError("HTTP Error: " + httpConnection.getResponseCode());
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (httpConnection != null) {
                        httpConnection.close();
                    }
                    if ((httpConnection = (HttpConnection)Connector.open((String)string2)).getResponseCode() == 200) {
                        inputStream = httpConnection.openInputStream();
                        MIDletStore.this.parseCsvData(inputStream);
                        MIDletStore.this.initializeUI();
                    } else {
                        MIDletStore.this.handleError("HTTP Error: " + httpConnection.getResponseCode());
                    }
                }
                catch (IOException iOException) {
                    MIDletStore.this.handleError("Connection Error: " + iOException.getMessage());
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (httpConnection != null) {
                            httpConnection.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        thread.start();
    }

    private String encode(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.' || c == '~') {
                stringBuffer.append(c);
                continue;
            }
            if (c == ' ') {
                stringBuffer.append('+');
                continue;
            }
            stringBuffer.append('%');
            stringBuffer.append(this.toHex(c >> 4 & 0xF));
            stringBuffer.append(this.toHex(c & 0xF));
        }
        return stringBuffer.toString();
    }

    private char toHex(int n) {
        return "0123456789ABCDEF".charAt(n);
    }

    private void parseCsvData(InputStream inputStream) throws IOException {
        int n;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStreamReader.read()) != -1) {
            if (n == 10) {
                this.processCsvLine(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                continue;
            }
            stringBuffer.append((char)n);
        }
        if (stringBuffer.length() > 0) {
            this.processCsvLine(stringBuffer.toString());
        }
    }

    private void processCsvLine(String string) {
        String[] stringArray = this.split(string, ',');
        if (stringArray.length >= 8) {
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            String string4 = stringArray[2];
            String string5 = stringArray[3];
            String string6 = stringArray[4];
            boolean bl = "true".equalsIgnoreCase(stringArray[5]);
            String string7 = stringArray[6];
            int n = 0;
            try {
                n = Integer.parseInt(stringArray[7]);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            MidletInfo midletInfo = new MidletInfo(string2, string3, string4, string5, string6, bl, string7, n);
            this.midletsList.addElement(midletInfo);
            if (bl) {
                this.featuredApps.addElement(midletInfo);
            }
        }
    }

    private String[] split(String string, char c) {
        int n;
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            if (n == c) {
                vector.addElement(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                continue;
            }
            stringBuffer.append((char)n);
        }
        vector.addElement(stringBuffer.toString());
        String[] stringArray = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            stringArray[n] = (String)vector.elementAt(n);
        }
        return stringArray;
    }

    private void initializeUI() {
        try {
            this.storeCanvas = new StoreCanvas(this, this.midletsList, this.featuredApps);
            this.storeCanvas.addCommand(this.exitCommand);
            this.storeCanvas.addCommand(this.selectCommand);
            Command command = new Command("Search", 8, 2);
            this.storeCanvas.addCommand(command);
            Command command2 = new Command("Top Charts", 8, 3);
            this.storeCanvas.addCommand(command2);
            this.storeCanvas.setCommandListener(this);
            this.display.setCurrent((Displayable)this.storeCanvas);
        }
        catch (Exception exception) {
            this.handleError("Error initializing UI: " + exception.getMessage());
        }
        this.isLoading = false;
    }

    public void showSearchPage() {
        if (this.searchPage == null) {
            this.searchPage = new SearchPage(this, this.midletsList);
        } else {
            this.searchPage.reset();
        }
        this.display.setCurrent((Displayable)this.searchPage);
    }

    public void showStoreCanvas() {
        this.display.setCurrent((Displayable)this.storeCanvas);
    }

    public void showTopChartsPage() {
        if (this.topChartsPage == null) {
            this.topChartsPage = new TopChartsPage(this);
        } else {
            this.topChartsPage.reset();
        }
        this.display.setCurrent((Displayable)this.topChartsPage);
    }

    public Image getIconForApp(int n) {
        if (n >= 0 && n < this.appIcons.size()) {
            return (Image)this.appIcons.elementAt(n);
        }
        return null;
    }

    public void setAppIcon(int n, Image image) {
        while (this.appIcons.size() <= n) {
            this.appIcons.addElement(null);
        }
        this.appIcons.setElementAt(image, n);
    }

    public void showAppDetails(MidletInfo midletInfo, Image image) {
        this.appDetailView = new AppDetailView(this, midletInfo, image);
        this.appDetailView.setCommandListener(this);
        this.display.setCurrent((Displayable)this.appDetailView);
    }

    public void installMidlet(final MidletInfo midletInfo) {
        Alert alert = new Alert("Installing", "Starting download of " + midletInfo.getName() + "...", null, AlertType.INFO);
        alert.setTimeout(3000);
        this.display.setCurrent(alert, (Displayable)this.storeCanvas);
        Thread thread = new Thread(){

            public void run() {
                try {
                    String string = midletInfo.getDownloadUrl();
                    if (MIDletStore.this.platformRequest(string)) {
                        MIDletStore.this.destroyApp(false);
                        MIDletStore.this.notifyDestroyed();
                    }
                }
                catch (Exception exception) {
                    Alert alert = new Alert("Error", "Failed to open download: " + exception.getMessage(), null, AlertType.ERROR);
                    alert.setTimeout(-2);
                    MIDletStore.this.display.setCurrent(alert, (Displayable)MIDletStore.this.storeCanvas);
                }
            }
        };
        thread.start();
    }

    private void handleError(String string) {
        Alert alert = new Alert("Error", string, null, AlertType.ERROR);
        alert.setTimeout(-2);
        this.display.setCurrent((Displayable)alert);
    }

    class MidletInfo {
        private String id;
        private String name;
        private String description;
        private String iconUrl;
        private String downloadUrl;
        private boolean featured;
        private String supportedStatus;
        private int votes;

        public MidletInfo(String string, String string2, String string3, String string4, String string5, boolean bl, String string6, int n) {
            this.id = string;
            this.name = string2;
            this.description = string3;
            this.iconUrl = string4;
            this.downloadUrl = string5;
            this.featured = bl;
            this.supportedStatus = string6;
            this.votes = n;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getIconUrl() {
            return this.iconUrl;
        }

        public String getDownloadUrl() {
            return this.downloadUrl;
        }

        public boolean isFeatured() {
            return this.featured;
        }

        public String getSupportedStatus() {
            return this.supportedStatus;
        }

        public int getVotes() {
            return this.votes;
        }

        public void setIconUrl(String string) {
            this.iconUrl = string;
        }

        public void setVotes(int n) {
            this.votes = n;
        }
    }
}

