/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class SearchPage
extends Canvas
implements CommandListener {
    private static final int HEADER_HEIGHT = 30;
    private static final int PADDING = 10;
    private static final int SEARCH_BOX_HEIGHT = 30;
    private static final int ITEM_HEIGHT = 60;
    private static final int COLOR_BACKGROUND = 0xF0F0F0;
    private static final int COLOR_HEADER = 15480656;
    private static final int COLOR_TEXT = 2899536;
    private static final int COLOR_HIGHLIGHT = 15220566;
    private static final int COLOR_WHITE = 0xFFFFFF;
    private static final int COLOR_LIGHT_GRAY = 0xD3D3D3;
    private static final int COLOR_GRAY = 8359053;
    private static final int COLOR_UPVOTE = 2600544;
    private static final int COLOR_DOWNVOTE = 12597547;
    private int width;
    private int height;
    private int contentHeight;
    private int scrollPosition = 0;
    private static final int MAX_SCROLL_SPEED = 20;
    private boolean isSearching = false;
    private String searchQuery = "";
    private int selectedResultIndex = -1;
    private int lastPointerY = 0;
    private boolean pointerPressed = false;
    private boolean searchBoxActive = false;
    private static final String SEARCH_API_URL = "http://localhost:3000/storeapi/search?q=";
    private Vector searchResults;
    private Vector resultIcons;
    private MIDletStore.MidletInfo selectedMidlet;
    private MIDletStore midletStore;
    private Vector midletsList;
    private Command backCommand;
    private Command searchCommand;
    private Command selectCommand;
    private Command clearCommand;
    private Command inputCommand;

    public SearchPage(MIDletStore mIDletStore, Vector vector) {
        this.midletStore = mIDletStore;
        this.midletsList = vector;
        this.searchResults = new Vector();
        this.resultIcons = new Vector();
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.backCommand = new Command("Back", 2, 1);
        this.searchCommand = new Command("Search", 4, 1);
        this.selectCommand = new Command("Select", 8, 1);
        this.clearCommand = new Command("Clear", 8, 2);
        this.inputCommand = new Command("Input", 8, 3);
        this.addCommand(this.backCommand);
        this.addCommand(this.searchCommand);
        this.addCommand(this.clearCommand);
        this.addCommand(this.inputCommand);
        this.setCommandListener(this);
    }

    private void performSearch() {
        if (this.searchQuery == null || this.searchQuery.trim().length() == 0) {
            Alert alert = new Alert("Error", "Please enter a search term", null, AlertType.WARNING);
            alert.setTimeout(2000);
            Display.getDisplay((MIDlet)this.midletStore).setCurrent(alert, (Displayable)this);
            return;
        }
        this.isSearching = true;
        this.searchResults.removeAllElements();
        this.resultIcons.removeAllElements();
        this.scrollPosition = 0;
        this.repaint();
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HttpConnection httpConnection = null;
                InputStream inputStream = null;
                try {
                    String string = SearchPage.SEARCH_API_URL + SearchPage.this.encode(SearchPage.this.searchQuery);
                    String string2 = SearchPage.this.midletStore.getDeviceQueryString();
                    if (string2 != null && string2.length() > 0) {
                        string = string + "&" + string2;
                    }
                    httpConnection = (HttpConnection)Connector.open((String)string);
                    httpConnection.setRequestProperty("User-Agent", "MIDletStore/1.0");
                    int n = httpConnection.getResponseCode();
                    if (n == 200) {
                        inputStream = httpConnection.openInputStream();
                        SearchPage.this.parseSearchResults(inputStream);
                    } else {
                        SearchPage.this.handleError("HTTP Error: " + n);
                    }
                }
                catch (IOException iOException) {
                    SearchPage.this.handleError("Connection Error: " + iOException.getMessage());
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (httpConnection != null) {
                            httpConnection.close();
                        }
                    }
                    catch (IOException iOException) {}
                    SearchPage.this.isSearching = false;
                    SearchPage.this.repaint();
                }
            }
        };
        thread.start();
    }

    private String encode(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.' || c == '~') {
                stringBuffer.append(c);
                continue;
            }
            if (c == ' ') {
                stringBuffer.append('+');
                continue;
            }
            stringBuffer.append('%');
            stringBuffer.append(this.toHex(c >> 4 & 0xF));
            stringBuffer.append(this.toHex(c & 0xF));
        }
        return stringBuffer.toString();
    }

    private char toHex(int n) {
        return "0123456789ABCDEF".charAt(n);
    }

    private void parseSearchResults(InputStream inputStream) throws IOException {
        int n;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStreamReader.read()) != -1) {
            if (n == 10) {
                this.processResultLine(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                continue;
            }
            stringBuffer.append((char)n);
        }
        if (stringBuffer.length() > 0) {
            this.processResultLine(stringBuffer.toString());
        }
        this.loadResultIcons();
    }

    private void processResultLine(String string) {
        String[] stringArray = this.split(string, ',');
        if (stringArray.length >= 8) {
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            String string4 = stringArray[2];
            String string5 = stringArray[3];
            String string6 = stringArray[4];
            boolean bl = "true".equalsIgnoreCase(stringArray[5]);
            String string7 = stringArray[6];
            int n = 0;
            try {
                n = Integer.parseInt(stringArray[7]);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            MIDletStore mIDletStore = this.midletStore;
            ((Object)((Object)mIDletStore)).getClass();
            MIDletStore.MidletInfo midletInfo = mIDletStore.new MIDletStore.MidletInfo(string2, string3, string4, string5, string6, bl, string7, n);
            this.searchResults.addElement(midletInfo);
            this.resultIcons.addElement(null);
        }
    }

    private String[] split(String string, char c) {
        int n;
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            if (n == c) {
                vector.addElement(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                continue;
            }
            stringBuffer.append((char)n);
        }
        vector.addElement(stringBuffer.toString());
        String[] stringArray = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            stringArray[n] = (String)vector.elementAt(n);
        }
        return stringArray;
    }

    private void handleError(String string) {
        Alert alert = new Alert("Search Error", string, null, AlertType.ERROR);
        alert.setTimeout(-2);
        Display.getDisplay((MIDlet)this.midletStore).setCurrent(alert, (Displayable)this);
    }

    private void loadResultIcons() {
        Thread thread = new Thread(){

            public void run() {
                for (int i = 0; i < SearchPage.this.searchResults.size(); ++i) {
                    MIDletStore.MidletInfo midletInfo = (MIDletStore.MidletInfo)SearchPage.this.searchResults.elementAt(i);
                    SearchPage.this.loadIconForResult(midletInfo, i);
                }
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIconForResult(MIDletStore.MidletInfo midletInfo, int n) {
        HttpConnection httpConnection = null;
        InputStream inputStream = null;
        try {
            byte[] byArray;
            if (midletInfo.getIconUrl() == null || midletInfo.getIconUrl().trim().length() == 0) {
                return;
            }
            httpConnection = (HttpConnection)Connector.open((String)midletInfo.getIconUrl());
            httpConnection.setRequestProperty("Accept", "image/png, image/gif, image/jpeg");
            httpConnection.setRequestProperty("User-Agent", "MIDletStore/1.0");
            int n2 = httpConnection.getResponseCode();
            if (n2 == 200 && (byArray = this.readFully(inputStream = httpConnection.openInputStream())) != null && byArray.length > 0) {
                try {
                    Image image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
                    this.resultIcons.setElementAt(image, n);
                    this.repaint();
                }
                catch (Exception exception) {
                    System.out.println("Error loading icon: " + exception.toString());
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error loading icon: " + exception.toString());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (httpConnection != null) {
                    httpConnection.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private byte[] readFully(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected void paint(Graphics graphics) {
        this.width = this.getWidth();
        this.height = this.getHeight();
        graphics.setColor(0xF0F0F0);
        graphics.fillRect(0, 0, this.width, this.height);
        this.drawHeader(graphics);
        this.drawSearchBox(graphics);
        if (this.isSearching) {
            this.drawSearchingIndicator(graphics);
        } else {
            this.drawSearchResults(graphics);
        }
    }

    private void drawHeader(Graphics graphics) {
        graphics.setColor(15480656);
        graphics.fillRect(0, 0, this.width, 30);
        graphics.setColor(0xFFFFFF);
        graphics.setFont(Font.getFont((int)0, (int)1, (int)0));
        this.drawCenteredText(graphics, "Search Apps", this.width / 2, 15);
        graphics.setColor(0xFFFFFF);
        graphics.fillTriangle(10, 15, 18, 7, 18, 23);
        this.drawText(graphics, "Back", 30, 15, false);
    }

    private void drawSearchBox(Graphics graphics) {
        int n = 40;
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(10, n, this.width - 20 - 70, 30);
        if (this.searchBoxActive) {
            graphics.setColor(15220566);
            graphics.drawRect(10, n, this.width - 20 - 70, 30);
        } else {
            graphics.setColor(0xD3D3D3);
            graphics.drawRect(10, n, this.width - 20 - 70, 30);
        }
        graphics.setColor(2899536);
        graphics.setFont(Font.getFont((int)0, (int)0, (int)0));
        String string = this.searchQuery;
        if (string.length() == 0) {
            graphics.setColor(8359053);
            string = "Search for apps...";
        }
        graphics.drawString(string, 20, n + 15 - graphics.getFont().getHeight() / 2, 20);
        if (this.searchBoxActive && System.currentTimeMillis() % 1000L < 500L) {
            graphics.setColor(15220566);
            int n2 = 20;
            if (this.searchQuery.length() > 0) {
                n2 += graphics.getFont().stringWidth(this.searchQuery);
            }
            graphics.drawLine(n2, n + 5, n2, n + 30 - 5);
        }
        graphics.setColor(15220566);
        graphics.fillRoundRect(this.width - 10 - 60, n, 60, 30, 5, 5);
        graphics.setColor(0xFFFFFF);
        graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
        this.drawText(graphics, "Search", this.width - 10 - 30, n + 15, true);
    }

    private void drawSearchResults(Graphics graphics) {
        int n;
        int n2 = 80;
        graphics.translate(0, -this.scrollPosition);
        if (this.searchResults.size() == 0) {
            graphics.setColor(2899536);
            graphics.setFont(Font.getFont((int)0, (int)0, (int)0));
            this.drawCenteredText(graphics, this.searchQuery.length() > 0 ? "No matching apps found" : "Enter a search term above", this.width / 2, n2 + 40);
            this.drawCenteredText(graphics, this.searchQuery.length() > 0 ? "" : "or use the Input command", this.width / 2, n2 + 50);
            return;
        }
        int n3 = n2;
        for (n = 0; n < this.searchResults.size(); ++n) {
            MIDletStore.MidletInfo midletInfo = (MIDletStore.MidletInfo)this.searchResults.elementAt(n);
            int n4 = n3;
            int n5 = 60;
            if (n == this.selectedResultIndex) {
                graphics.setColor(0xD3D3D3);
                graphics.fillRect(0, n4, this.width, n5);
            }
            Image image = null;
            if (n < this.resultIcons.size()) {
                image = (Image)this.resultIcons.elementAt(n);
            }
            if (image != null) {
                graphics.drawImage(image, 10, n4 + n5 / 2, 6);
            } else {
                graphics.setColor(0xD3D3D3);
                graphics.fillRect(10, n4 + 5, 32, 32);
            }
            int n6 = 60;
            graphics.setColor(2899536);
            graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
            graphics.drawString(midletInfo.getName(), n6, n4 + 10, 20);
            graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
            String string = midletInfo.getDescription();
            if (string.length() > 50) {
                string = string.substring(0, 47) + "...";
            }
            graphics.drawString(string, n6, n4 + 30, 20);
            graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
            int n7 = midletInfo.getVotes();
            String string2 = String.valueOf(n7);
            if (n7 > 0) {
                string2 = "+" + string2;
                graphics.setColor(2600544);
            } else if (n7 < 0) {
                graphics.setColor(12597547);
            } else {
                graphics.setColor(8359053);
            }
            int n8 = this.width - 10 - 30;
            int n9 = n4 + n5 / 2;
            int n10 = graphics.getFont().stringWidth(string2) + 10;
            graphics.fillRoundRect(n8 - n10 / 2, n9 - 10, n10, 20, 6, 6);
            graphics.setColor(0xFFFFFF);
            graphics.drawString(string2, n8 - graphics.getFont().stringWidth(string2) / 2, n9 - graphics.getFont().getHeight() / 2, 20);
            graphics.setColor(0xD3D3D3);
            graphics.drawLine(0, n4 + n5, this.width, n4 + n5);
            n3 += n5;
        }
        this.contentHeight = n3 - n2;
        graphics.translate(0, this.scrollPosition);
        if (this.contentHeight > this.height - n2) {
            if (this.scrollPosition > 0) {
                graphics.setColor(8359053);
                n = this.width / 2;
                int n11 = n2 + 10;
                graphics.fillTriangle(n, n11, n - 10, n11 + 10, n + 10, n11 + 10);
            }
            if (this.scrollPosition < this.contentHeight - (this.height - n2)) {
                graphics.setColor(8359053);
                n = this.width / 2;
                int n12 = this.height - 10;
                graphics.fillTriangle(n, n12, n - 10, n12 - 10, n + 10, n12 - 10);
            }
        }
    }

    private void drawSearchingIndicator(Graphics graphics) {
        int n = (this.height - 30 - 30) / 2 + 30 + 30;
        graphics.setColor(2899536);
        graphics.setFont(Font.getFont((int)0, (int)1, (int)0));
        this.drawCenteredText(graphics, "Searching...", this.width / 2, n);
    }

    private void drawText(Graphics graphics, String string, int n, int n2, boolean bl) {
        int n3;
        if (bl) {
            n3 = graphics.getFont().stringWidth(string);
            n -= n3 / 2;
        }
        n3 = graphics.getFont().getHeight();
        graphics.drawString(string, n, n2 -= n3 / 2, 20);
    }

    private void drawCenteredText(Graphics graphics, String string, int n, int n2) {
        Font font = graphics.getFont();
        int n3 = font.stringWidth(string);
        int n4 = font.getHeight();
        graphics.drawString(string, n - n3 / 2, n2 - n4 / 2, 20);
    }

    private void showTextInput() {
        Display display = Display.getDisplay((MIDlet)this.midletStore);
        TextInputForm textInputForm = new TextInputForm("Search", this.searchQuery, this);
        display.setCurrent((Displayable)textInputForm);
    }

    public void setSearchQuery(String string) {
        this.searchQuery = string;
        this.searchBoxActive = false;
        this.repaint();
    }

    public void returnToSearchPage(Displayable displayable) {
        if (this.midletStore != null) {
            Display.getDisplay((MIDlet)this.midletStore).setCurrent((Displayable)this);
        }
        this.searchBoxActive = false;
        this.performSearch();
    }

    protected void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        if (this.searchBoxActive) {
            if (n2 == 8) {
                this.searchBoxActive = false;
                this.performSearch();
                return;
            }
        } else if (n2 == 1) {
            if (this.selectedResultIndex > 0) {
                --this.selectedResultIndex;
                this.ensureSelectedVisible();
                this.repaint();
            } else if (this.selectedResultIndex == -1 && this.searchResults.size() > 0) {
                this.selectedResultIndex = 0;
                this.repaint();
            }
        } else if (n2 == 6) {
            if (this.selectedResultIndex < this.searchResults.size() - 1) {
                ++this.selectedResultIndex;
                this.ensureSelectedVisible();
                this.repaint();
            }
        } else if (n2 == 8 && this.selectedResultIndex >= 0) {
            this.openSelectedApp();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.backCommand) {
            this.midletStore.showStoreCanvas();
        } else if (command == this.searchCommand) {
            this.searchBoxActive = false;
            this.performSearch();
        } else if (command == this.clearCommand) {
            this.searchQuery = "";
            this.repaint();
        } else if (command == this.inputCommand) {
            this.showTextInput();
        } else if (command == this.selectCommand && this.selectedResultIndex >= 0) {
            this.openSelectedApp();
        }
    }

    private void openSelectedApp() {
        if (this.selectedResultIndex >= 0 && this.selectedResultIndex < this.searchResults.size()) {
            MIDletStore.MidletInfo midletInfo = (MIDletStore.MidletInfo)this.searchResults.elementAt(this.selectedResultIndex);
            Image image = null;
            if (this.selectedResultIndex < this.resultIcons.size()) {
                image = (Image)this.resultIcons.elementAt(this.selectedResultIndex);
            }
            this.midletStore.showAppDetails(midletInfo, image);
        }
    }

    private void ensureSelectedVisible() {
        int n;
        if (this.selectedResultIndex < 0) {
            return;
        }
        int n2 = 80;
        int n3 = n2 + this.selectedResultIndex * 60;
        int n4 = n3 + 60;
        if (n3 - this.scrollPosition < n2) {
            this.scrollPosition = n3 - n2;
        } else if (n4 - this.scrollPosition > this.height) {
            this.scrollPosition = n4 - this.height;
        }
        if (this.scrollPosition < 0) {
            this.scrollPosition = 0;
        }
        if (this.scrollPosition > (n = Math.max(0, this.contentHeight - (this.height - n2)))) {
            this.scrollPosition = n;
        }
    }

    protected void pointerPressed(int n, int n2) {
        int n3;
        int n4;
        int n5;
        this.pointerPressed = true;
        this.lastPointerY = n2;
        int n6 = 40;
        if (n2 >= n6 && n2 <= n6 + 30) {
            if (n >= this.width - 10 - 60 && n <= this.width - 10) {
                this.searchBoxActive = false;
                this.performSearch();
            } else if (n >= 10 && n <= this.width - 20 - 70) {
                this.showTextInput();
            }
            return;
        }
        if (this.searchResults.size() > 0 && (n5 = n2 + this.scrollPosition) >= (n4 = 80) && (n3 = (n5 - n4) / 60) >= 0 && n3 < this.searchResults.size()) {
            if (this.selectedResultIndex == n3) {
                this.openSelectedApp();
            } else {
                this.selectedResultIndex = n3;
                this.repaint();
            }
        }
    }

    protected void pointerDragged(int n, int n2) {
        int n3;
        int n4;
        if (!this.pointerPressed) {
            return;
        }
        int n5 = this.lastPointerY - n2;
        this.lastPointerY = n2;
        if (Math.abs(n5) < 2) {
            return;
        }
        this.scrollPosition += n5;
        if (this.scrollPosition < 0) {
            this.scrollPosition = 0;
        }
        if (this.scrollPosition > (n4 = Math.max(0, this.contentHeight - (this.height - (n3 = 80))))) {
            this.scrollPosition = n4;
        }
        this.repaint();
    }

    protected void pointerReleased(int n, int n2) {
        this.pointerPressed = false;
    }

    public void reset() {
        this.searchQuery = "";
        this.searchBoxActive = false;
        this.selectedResultIndex = -1;
        this.scrollPosition = 0;
        this.searchResults.removeAllElements();
        this.resultIcons.removeAllElements();
        this.repaint();
    }
}

