/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class StoreCanvas
extends Canvas {
    private static final int HEADER_HEIGHT = 30;
    private static final int CAROUSEL_HEIGHT = 100;
    private static final int ITEM_WIDTH = 80;
    private static final int ITEM_HEIGHT = 80;
    private static final int ITEM_SPACING = 10;
    private static final int ITEMS_PER_ROW = 2;
    private static final int VISIBLE_ROWS = 3;
    private static final int ANIMATION_DURATION = 300;
    private static final int ANIMATION_STEPS = 10;
    private static final int COLOR_BACKGROUND = 0xF0F0F0;
    private static final int COLOR_HEADER = 15480656;
    private static final int COLOR_CAROUSEL_BG = 16762830;
    private static final int COLOR_TEXT = 2899536;
    private static final int COLOR_HIGHLIGHT = 15220566;
    private static final int COLOR_WHITE = 0xFFFFFF;
    private static final int COLOR_GRAY = 0xAAAAAA;
    private static final int COLOR_UPVOTE = 2600544;
    private static final int COLOR_DOWNVOTE = 12597547;
    private int width;
    private int height;
    private int gridStartY;
    private MIDletStore midletStore;
    private Vector midletsList;
    private Vector featuredApps;
    private Vector appIcons;
    private MIDletStore.MidletInfo selectedMidlet;
    private int currentFeaturedIndex = 0;
    private int scrollPosition = 0;
    private int selectedIndex = 0;
    private boolean carouselMode = true;
    private boolean isAnimating = false;
    private long animationStartTime = 0L;
    private int animationStartPosition = 0;
    private int animationTargetPosition = 0;
    private int animationCurrentStep = 0;
    private Image defaultAppIcon;

    public StoreCanvas(MIDletStore mIDletStore, Vector vector, Vector vector2) {
        this.midletStore = mIDletStore;
        this.midletsList = vector;
        this.featuredApps = vector2;
        this.appIcons = new Vector();
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.gridStartY = 155;
        for (int i = 0; i < vector.size(); ++i) {
            this.appIcons.addElement(null);
        }
        try {
            this.defaultAppIcon = Image.createImage((String)"/default_icon.png");
        }
        catch (IOException iOException) {
            this.defaultAppIcon = this.createDefaultIcon();
        }
        this.loadAppIcons();
    }

    private Image createDefaultIcon() {
        Image image = Image.createImage((int)32, (int)32);
        Graphics graphics = image.getGraphics();
        graphics.setColor(15220566);
        graphics.fillRect(0, 0, 32, 32);
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(0, 0, 31, 31);
        graphics.setColor(0xFFFFFF);
        graphics.drawLine(11, 22, 16, 8);
        graphics.drawLine(16, 8, 21, 22);
        graphics.drawLine(13, 16, 19, 16);
        return image;
    }

    private void loadAppIcons() {
        Thread thread = new Thread(){

            public void run() {
                for (int i = 0; i < StoreCanvas.this.midletsList.size(); ++i) {
                    MIDletStore.MidletInfo midletInfo = (MIDletStore.MidletInfo)StoreCanvas.this.midletsList.elementAt(i);
                    StoreCanvas.this.loadIconForMidlet(midletInfo, i);
                }
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIconForMidlet(MIDletStore.MidletInfo midletInfo, int n) {
        block28: {
            HttpConnection httpConnection = null;
            InputStream inputStream = null;
            try {
                if (midletInfo.getIconUrl() == null || midletInfo.getIconUrl().trim().length() == 0) {
                    this.appIcons.setElementAt(this.defaultAppIcon, n);
                    this.midletStore.setAppIcon(n, this.defaultAppIcon);
                    return;
                }
                httpConnection = (HttpConnection)Connector.open((String)midletInfo.getIconUrl());
                httpConnection.setRequestProperty("Accept", "image/png, image/gif, image/jpeg");
                httpConnection.setRequestProperty("User-Agent", "MIDletStore/1.0");
                int n2 = httpConnection.getResponseCode();
                if (n2 == 200) {
                    inputStream = httpConnection.openInputStream();
                    String string = httpConnection.getHeaderField("Content-Type");
                    if (string != null && string.startsWith("image/")) {
                        try {
                            byte[] byArray = this.readFully(inputStream);
                            if (byArray != null && byArray.length > 0) {
                                try {
                                    Image image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
                                    this.appIcons.setElementAt(image, n);
                                    this.midletStore.setAppIcon(n, image);
                                    this.repaint();
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    System.out.println("Invalid image format: " + illegalArgumentException.toString());
                                    this.appIcons.setElementAt(this.defaultAppIcon, n);
                                    this.midletStore.setAppIcon(n, this.defaultAppIcon);
                                }
                                break block28;
                            }
                            System.out.println("Empty image data received");
                            this.appIcons.setElementAt(this.defaultAppIcon, n);
                            this.midletStore.setAppIcon(n, this.defaultAppIcon);
                        }
                        catch (Exception exception) {
                            System.out.println("Error processing image: " + exception.toString());
                            this.appIcons.setElementAt(this.defaultAppIcon, n);
                            this.midletStore.setAppIcon(n, this.defaultAppIcon);
                        }
                        break block28;
                    }
                    System.out.println("Non-image content type: " + string);
                    this.appIcons.setElementAt(this.defaultAppIcon, n);
                    this.midletStore.setAppIcon(n, this.defaultAppIcon);
                    break block28;
                }
                System.out.println("Failed to load icon: HTTP " + n2);
                this.appIcons.setElementAt(this.defaultAppIcon, n);
                this.midletStore.setAppIcon(n, this.defaultAppIcon);
            }
            catch (IOException iOException) {
                System.out.println("Icon loading failed: " + iOException.toString());
                this.appIcons.setElementAt(this.defaultAppIcon, n);
                this.midletStore.setAppIcon(n, this.defaultAppIcon);
            }
            catch (Exception exception) {
                System.out.println("Unexpected error loading icon: " + exception.toString());
                this.appIcons.setElementAt(this.defaultAppIcon, n);
                this.midletStore.setAppIcon(n, this.defaultAppIcon);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (httpConnection != null) {
                        httpConnection.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    private byte[] readFully(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected void paint(Graphics graphics) {
        this.width = this.getWidth();
        this.height = this.getHeight();
        graphics.setColor(0xF0F0F0);
        graphics.fillRect(0, 0, this.width, this.height);
        this.drawHeader(graphics);
        this.drawCarousel(graphics);
        this.drawAppGrid(graphics);
        this.drawNavigationHint(graphics);
    }

    private void drawHeader(Graphics graphics) {
        graphics.setColor(15480656);
        graphics.fillRect(0, 0, this.width, 30);
        graphics.setColor(0xFFFFFF);
        graphics.setFont(this.deriveFont(1));
        this.drawCenteredText(graphics, "Hack MIDlet Store", this.width / 2, 15);
    }

    private void drawCarousel(Graphics graphics) {
        int n;
        int n2;
        int n3 = 30;
        graphics.setColor(16762830);
        graphics.fillRect(0, n3, this.width, 100);
        graphics.setColor(2899536);
        graphics.setFont(this.deriveFont(1));
        graphics.drawString("Featured Apps", 10, n3 + 5, 20);
        if (this.featuredApps.size() == 0) {
            this.drawCenteredText(graphics, "No featured apps", this.width / 2, n3 + 50);
            return;
        }
        int n4 = 0;
        if (this.isAnimating) {
            long l = System.currentTimeMillis();
            float f = (float)(l - this.animationStartTime) / 300.0f;
            if (f >= 1.0f) {
                this.isAnimating = false;
                this.currentFeaturedIndex = this.animationTargetPosition;
            } else {
                f = 1.0f - (1.0f - f) * (1.0f - f);
                n2 = -1;
                int n5 = this.animationTargetPosition - this.animationStartPosition;
                n = 0;
                n = n5 > 0 ? n5 - this.featuredApps.size() : n5 + this.featuredApps.size();
                n2 = Math.abs(n) < Math.abs(n5) ? (n > 0 ? 1 : -1) : (n5 > 0 ? -1 : 1);
                n4 = (int)((float)(n2 * this.width) * f);
            }
        }
        int n6 = 70;
        int n7 = n3 + 25;
        for (int i = -1; i <= 1; ++i) {
            n2 = (this.currentFeaturedIndex + i + this.featuredApps.size()) % this.featuredApps.size();
            MIDletStore.MidletInfo midletInfo = (MIDletStore.MidletInfo)this.featuredApps.elementAt(n2);
            n = this.width * i + this.width / 2 + n4;
            if (n + this.width / 2 < 0 || n - this.width / 2 > this.width) continue;
            graphics.setColor(0xFFFFFF);
            graphics.fillRoundRect(n - this.width / 2 + 20, n7, this.width - 40, n6, 15, 15);
            int n8 = this.midletsList.indexOf(midletInfo);
            if (n8 >= 0) {
                Image image = (Image)this.appIcons.elementAt(n8);
                if (image == null) {
                    image = this.defaultAppIcon;
                }
                int n9 = Math.min(image.getWidth(), image.getHeight());
                int n10 = n;
                int n11 = n7 + n6 / 2 - 10;
                graphics.drawImage(image, n10, n11, 3);
            }
            graphics.setColor(2899536);
            graphics.setFont(this.deriveFont(1));
            this.drawCenteredText(graphics, midletInfo.getName(), n, n7 + n6 - 15);
        }
        this.drawPaginationDots(graphics, this.featuredApps.size(), this.currentFeaturedIndex, this.width / 2, n3 + 100 - 10);
    }

    private void drawPaginationDots(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 6;
        int n6 = 10;
        int n7 = n * n6;
        int n8 = n3 - n7 / 2 + n6 / 2;
        for (int i = 0; i < n; ++i) {
            int n9 = n8 + i * n6;
            if (i == n2) {
                graphics.setColor(15220566);
                graphics.fillRoundRect(n9 - n5 / 2, n4 - n5 / 2, n5, n5, n5, n5);
                continue;
            }
            graphics.setColor(2899536);
            graphics.drawRoundRect(n9 - n5 / 2, n4 - n5 / 2, n5, n5, n5, n5);
        }
    }

    private void drawAppGrid(Graphics graphics) {
        graphics.setColor(2899536);
        graphics.setFont(this.deriveFont(0));
        graphics.drawString("All Applications", 10, this.gridStartY - 20, 20);
        if (this.midletsList.size() == 0) {
            this.drawCenteredText(graphics, "No applications available", this.width / 2, this.gridStartY + 40);
            return;
        }
        int n = this.width / 2;
        int n2 = 100;
        int n3 = this.scrollPosition * 2;
        int n4 = Math.min(this.midletsList.size(), n3 + 6);
        graphics.setColor(2899536);
        graphics.setFont(this.deriveFont(0));
        String string = "Sel: " + this.selectedIndex + " Row: " + this.selectedIndex / 2 + " Col: " + this.selectedIndex % 2 + " Scroll: " + this.scrollPosition;
        graphics.drawString(string, 5, this.gridStartY + 3 * n2 + 5, 20);
        for (int i = n3; i < n4; ++i) {
            int n5;
            int n6;
            int n7 = i - n3;
            int n8 = n7 / 2;
            int n9 = n7 % 2;
            int n10 = n9 * n + n / 2;
            int n11 = this.gridStartY + n8 * n2;
            MIDletStore.MidletInfo midletInfo = (MIDletStore.MidletInfo)this.midletsList.elementAt(i);
            if (!this.carouselMode && n7 == this.selectedIndex) {
                graphics.setColor(15220566);
                graphics.fillRoundRect(n10 - 40 - 5, n11 - 5, 90, 90, 10, 10);
            }
            graphics.setColor(0xFFFFFF);
            graphics.fillRoundRect(n10 - 40, n11, 80, 80, 5, 5);
            Image image = (Image)this.appIcons.elementAt(i);
            if (image == null) {
                image = this.defaultAppIcon;
            }
            graphics.drawImage(image, n10, n11 + 40, 3);
            if (midletInfo.getSupportedStatus() != null) {
                String string2 = midletInfo.getSupportedStatus();
                n6 = 0xAAAAAA;
                if (string2.equals("fully_supported")) {
                    n6 = 43520;
                } else if (string2.equals("partially_supported")) {
                    n6 = 0xFFAA00;
                } else if (string2.equals("not_supported")) {
                    n6 = 0xAA0000;
                }
                graphics.setColor(n6);
                graphics.fillRect(n10 + 40 - 10, n11, 10, 10);
            }
            if ((n5 = midletInfo.getVotes()) != 0) {
                n6 = 10;
                int n12 = n10 + 40 - n6 - 1;
                int n13 = n11 + 80 - n6 - 1;
                if (n5 > 0) {
                    graphics.setColor(2600544);
                    graphics.fillTriangle(n12 + n6 / 2, n13, n12 + n6, n13 + n6, n12, n13 + n6);
                } else {
                    graphics.setColor(12597547);
                    graphics.fillTriangle(n12, n13, n12 + n6, n13, n12 + n6 / 2, n13 + n6);
                }
            }
            graphics.setColor(2899536);
            graphics.setFont(this.deriveFont(0));
            this.drawCenteredText(graphics, midletInfo.getName(), n10, n11 + 80 + 10);
        }
    }

    private void drawNavigationHint(Graphics graphics) {
        graphics.setColor(15480656);
        graphics.fillRect(0, this.height - 20, this.width, 20);
        graphics.setColor(0xFFFFFF);
        graphics.setFont(this.deriveFont(0));
        this.drawCenteredText(graphics, "Use arrow keys to navigate, SELECT to choose", this.width / 2, this.height - 10);
    }

    private void drawCenteredText(Graphics graphics, String string, int n, int n2) {
        javax.microedition.lcdui.Font font = graphics.getFont();
        int n3 = font.stringWidth(string);
        int n4 = font.getHeight();
        int n5 = n - n3 / 2;
        int n6 = n2 - n4 / 2;
        graphics.drawString(string, n5, n6, 20);
    }

    protected void keyPressed(int n) {
        int n2;
        int n3 = this.getGameAction(n);
        if (this.carouselMode) {
            if (n3 == 2 && !this.isAnimating) {
                if (this.featuredApps.size() > 1) {
                    this.isAnimating = true;
                    this.animationStartTime = System.currentTimeMillis();
                    this.animationStartPosition = this.currentFeaturedIndex;
                    this.animationTargetPosition = (this.currentFeaturedIndex - 1 + this.featuredApps.size()) % this.featuredApps.size();
                    this.repaint();
                    this.startCarouselAnimation();
                }
            } else if (n3 == 5 && !this.isAnimating) {
                if (this.featuredApps.size() > 1) {
                    this.isAnimating = true;
                    this.animationStartTime = System.currentTimeMillis();
                    this.animationStartPosition = this.currentFeaturedIndex;
                    this.animationTargetPosition = (this.currentFeaturedIndex + 1) % this.featuredApps.size();
                    this.repaint();
                    this.startCarouselAnimation();
                }
            } else if (n3 == 6) {
                this.carouselMode = false;
                this.selectedIndex = 0;
                this.repaint();
            } else if (n3 == 8 && this.featuredApps.size() > 0) {
                this.selectedMidlet = (MIDletStore.MidletInfo)this.featuredApps.elementAt(this.currentFeaturedIndex);
                this.midletStore.showAppDetails(this.selectedMidlet, (Image)this.appIcons.elementAt(this.midletsList.indexOf(this.selectedMidlet)));
            }
        } else if (n3 == 2) {
            if (this.selectedIndex % 2 > 0) {
                --this.selectedIndex;
                this.repaint();
            }
        } else if (n3 == 5) {
            if (this.selectedIndex % 2 < 1 && this.selectedIndex + this.scrollPosition * 2 + 1 < this.midletsList.size()) {
                ++this.selectedIndex;
                this.repaint();
            }
        } else if (n3 == 1) {
            if (this.selectedIndex >= 2) {
                this.selectedIndex -= 2;
                this.repaint();
            } else if (this.scrollPosition > 0) {
                --this.scrollPosition;
                this.repaint();
            } else {
                this.carouselMode = true;
                this.repaint();
            }
        } else if (n3 == 6) {
            int n4 = this.selectedIndex + 2;
            if (n4 < 6 && n4 + this.scrollPosition * 2 < this.midletsList.size()) {
                this.selectedIndex = n4;
                this.repaint();
            } else if ((this.scrollPosition + 1) * 2 + this.selectedIndex % 2 < this.midletsList.size()) {
                ++this.scrollPosition;
                int n5 = this.selectedIndex % 2;
                int n6 = this.scrollPosition * 2 + n5;
                if (n6 >= this.midletsList.size()) {
                    n5 = (this.midletsList.size() - 1) % 2;
                }
                this.selectedIndex = n5;
                this.repaint();
            }
        } else if (n3 == 8 && (n2 = this.selectedIndex + this.scrollPosition * 2) < this.midletsList.size()) {
            this.selectedMidlet = (MIDletStore.MidletInfo)this.midletsList.elementAt(n2);
            this.midletStore.showAppDetails(this.selectedMidlet, (Image)this.appIcons.elementAt(n2));
        }
    }

    private void startCarouselAnimation() {
        Thread thread = new Thread(){

            public void run() {
                try {
                    while (StoreCanvas.this.isAnimating) {
                        StoreCanvas.this.repaint();
                        Thread.sleep(30L);
                    }
                    StoreCanvas.this.repaint();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        thread.start();
    }

    public MIDletStore.MidletInfo getSelectedMidlet() {
        MIDletStore.MidletInfo midletInfo = this.selectedMidlet;
        this.selectedMidlet = null;
        this.repaint();
        return midletInfo;
    }

    private javax.microedition.lcdui.Font deriveFont(int n) {
        if (n == 1) {
            return javax.microedition.lcdui.Font.getFont((int)0, (int)1, (int)0);
        }
        return javax.microedition.lcdui.Font.getFont((int)0, (int)0, (int)0);
    }

    private static class Font {
        public static final int STYLE_PLAIN = 0;
        public static final int STYLE_BOLD = 1;

        private Font() {
        }
    }
}

