/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class TopChartsPage
extends Canvas
implements CommandListener {
    private static final int HEADER_HEIGHT = 30;
    private static final int CATEGORY_SELECTOR_HEIGHT = 45;
    private static final int PADDING = 10;
    private static final int ITEM_HEIGHT = 60;
    private static final int COLOR_BACKGROUND = 0xF0F0F0;
    private static final int COLOR_HEADER = 15480656;
    private static final int COLOR_TEXT = 2899536;
    private static final int COLOR_HIGHLIGHT = 15220566;
    private static final int COLOR_WHITE = 0xFFFFFF;
    private static final int COLOR_LIGHT_GRAY = 0xD3D3D3;
    private static final int COLOR_GRAY = 8359053;
    private static final int COLOR_UPVOTE = 2600544;
    private static final int COLOR_DOWNVOTE = 12597547;
    private static final String TOP_CHARTS_API_URL = "http://localhost:3000/storeapi/topchart?category=";
    private static final String[] CATEGORIES = new String[]{"games", "utilities", "entertainment", "productivity", "education", "social", "lifestyle", "finance", "health", "news"};
    private static final String[] CATEGORY_NAMES = new String[]{"Games", "Utilities", "Entertainment", "Productivity", "Education", "Social", "Lifestyle", "Finance", "Health", "News"};
    private int width;
    private int height;
    private int contentHeight;
    private int scrollPosition = 0;
    private static final int MAX_SCROLL_SPEED = 20;
    private boolean isLoading = false;
    private int selectedCategoryIndex = 0;
    private int selectedAppIndex = -1;
    private int lastPointerY = 0;
    private boolean pointerPressed = false;
    private Vector chartApps;
    private Vector appIcons;
    private MIDletStore midletStore;
    private Command backCommand;
    private Command selectCommand;
    private Command refreshCommand;

    public TopChartsPage(MIDletStore mIDletStore) {
        this.midletStore = mIDletStore;
        this.chartApps = new Vector();
        this.appIcons = new Vector();
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.backCommand = new Command("Back", 2, 1);
        this.selectCommand = new Command("Select", 8, 1);
        this.refreshCommand = new Command("Refresh", 8, 2);
        this.addCommand(this.backCommand);
        this.addCommand(this.selectCommand);
        this.addCommand(this.refreshCommand);
        this.setCommandListener(this);
        this.loadCategoryApps(this.selectedCategoryIndex);
    }

    private void loadCategoryApps(int n) {
        this.isLoading = true;
        this.chartApps.removeAllElements();
        this.appIcons.removeAllElements();
        this.scrollPosition = 0;
        this.selectedAppIndex = -1;
        this.repaint();
        final String string = CATEGORIES[n];
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HttpConnection httpConnection = null;
                InputStream inputStream = null;
                try {
                    String string3 = TopChartsPage.TOP_CHARTS_API_URL + TopChartsPage.this.encode(string);
                    String string2 = TopChartsPage.this.midletStore.getDeviceQueryString();
                    if (string2 != null && string2.length() > 0) {
                        string3 = string3 + "&" + string2;
                    }
                    httpConnection = (HttpConnection)Connector.open((String)string3);
                    httpConnection.setRequestProperty("User-Agent", "MIDletStore/1.0");
                    int n = httpConnection.getResponseCode();
                    if (n == 200) {
                        inputStream = httpConnection.openInputStream();
                        TopChartsPage.this.parseChartResults(inputStream);
                    } else {
                        TopChartsPage.this.handleError("HTTP Error: " + n);
                    }
                }
                catch (IOException iOException) {
                    TopChartsPage.this.handleError("Connection Error: " + iOException.getMessage());
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (httpConnection != null) {
                            httpConnection.close();
                        }
                    }
                    catch (IOException iOException) {}
                    TopChartsPage.this.isLoading = false;
                    TopChartsPage.this.repaint();
                }
            }
        };
        thread.start();
    }

    private String encode(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.' || c == '~') {
                stringBuffer.append(c);
                continue;
            }
            if (c == ' ') {
                stringBuffer.append('+');
                continue;
            }
            stringBuffer.append('%');
            stringBuffer.append(this.toHex(c >> 4 & 0xF));
            stringBuffer.append(this.toHex(c & 0xF));
        }
        return stringBuffer.toString();
    }

    private char toHex(int n) {
        return "0123456789ABCDEF".charAt(n);
    }

    private void parseChartResults(InputStream inputStream) throws IOException {
        int n;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStreamReader.read()) != -1) {
            if (n == 10) {
                this.processChartLine(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                continue;
            }
            stringBuffer.append((char)n);
        }
        if (stringBuffer.length() > 0) {
            this.processChartLine(stringBuffer.toString());
        }
        this.loadAppIcons();
    }

    private void processChartLine(String string) {
        String[] stringArray = this.split(string, ',');
        if (stringArray.length >= 8) {
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            String string4 = stringArray[2];
            String string5 = stringArray[3];
            String string6 = stringArray[4];
            boolean bl = "true".equalsIgnoreCase(stringArray[5]);
            String string7 = stringArray[6];
            int n = 0;
            try {
                n = Integer.parseInt(stringArray[7]);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            MIDletStore mIDletStore = this.midletStore;
            ((Object)((Object)mIDletStore)).getClass();
            MIDletStore.MidletInfo midletInfo = mIDletStore.new MIDletStore.MidletInfo(string2, string3, string4, string5, string6, bl, string7, n);
            this.chartApps.addElement(midletInfo);
            this.appIcons.addElement(null);
        }
    }

    private String[] split(String string, char c) {
        int n;
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            if (n == c) {
                vector.addElement(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                continue;
            }
            stringBuffer.append((char)n);
        }
        vector.addElement(stringBuffer.toString());
        String[] stringArray = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            stringArray[n] = (String)vector.elementAt(n);
        }
        return stringArray;
    }

    private void handleError(String string) {
        Alert alert = new Alert("Chart Error", string, null, AlertType.ERROR);
        alert.setTimeout(-2);
        Display.getDisplay((MIDlet)this.midletStore).setCurrent(alert, (Displayable)this);
    }

    private void loadAppIcons() {
        Thread thread = new Thread(){

            public void run() {
                for (int i = 0; i < TopChartsPage.this.chartApps.size(); ++i) {
                    MIDletStore.MidletInfo midletInfo = (MIDletStore.MidletInfo)TopChartsPage.this.chartApps.elementAt(i);
                    TopChartsPage.this.loadIconForApp(midletInfo, i);
                }
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIconForApp(MIDletStore.MidletInfo midletInfo, int n) {
        HttpConnection httpConnection = null;
        InputStream inputStream = null;
        try {
            byte[] byArray;
            if (midletInfo.getIconUrl() == null || midletInfo.getIconUrl().trim().length() == 0) {
                return;
            }
            httpConnection = (HttpConnection)Connector.open((String)midletInfo.getIconUrl());
            httpConnection.setRequestProperty("Accept", "image/png, image/gif, image/jpeg");
            httpConnection.setRequestProperty("User-Agent", "MIDletStore/1.0");
            int n2 = httpConnection.getResponseCode();
            if (n2 == 200 && (byArray = this.readFully(inputStream = httpConnection.openInputStream())) != null && byArray.length > 0) {
                try {
                    Image image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
                    this.appIcons.setElementAt(image, n);
                    this.repaint();
                }
                catch (Exception exception) {
                    System.out.println("Error loading icon: " + exception.toString());
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error loading icon: " + exception.toString());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (httpConnection != null) {
                    httpConnection.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private byte[] readFully(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected void paint(Graphics graphics) {
        this.width = this.getWidth();
        this.height = this.getHeight();
        graphics.setColor(0xF0F0F0);
        graphics.fillRect(0, 0, this.width, this.height);
        this.drawHeader(graphics);
        this.drawCategorySelector(graphics);
        if (this.isLoading) {
            this.drawLoadingIndicator(graphics);
        } else {
            this.drawChartList(graphics);
        }
    }

    private void drawHeader(Graphics graphics) {
        graphics.setColor(15480656);
        graphics.fillRect(0, 0, this.width, 30);
        graphics.setColor(0xFFFFFF);
        graphics.setFont(Font.getFont((int)0, (int)1, (int)0));
        this.drawCenteredText(graphics, "Top Charts", this.width / 2, 15);
        graphics.setColor(0xFFFFFF);
        graphics.fillTriangle(10, 15, 18, 7, 18, 23);
        this.drawText(graphics, "Back", 30, 15, false);
    }

    private void drawCategorySelector(Graphics graphics) {
        int n = 30;
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, n, this.width, 45);
        graphics.setColor(15220566);
        graphics.setFont(Font.getFont((int)0, (int)1, (int)0));
        this.drawCenteredText(graphics, CATEGORY_NAMES[this.selectedCategoryIndex], this.width / 2, n + 22 - 8);
        graphics.setColor(8359053);
        graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
        this.drawCenteredText(graphics, "Press numpad keys 1-" + CATEGORIES.length + " to change category", this.width / 2, n + 45 - 12);
    }

    private void drawChartList(Graphics graphics) {
        int n;
        int n2 = 75;
        graphics.translate(0, -this.scrollPosition);
        if (this.chartApps.size() == 0) {
            graphics.setColor(2899536);
            graphics.setFont(Font.getFont((int)0, (int)0, (int)0));
            this.drawCenteredText(graphics, "No apps in this category", this.width / 2, n2 + 50);
            return;
        }
        int n3 = n2 + 10;
        for (n = 0; n < this.chartApps.size(); ++n) {
            MIDletStore.MidletInfo midletInfo = (MIDletStore.MidletInfo)this.chartApps.elementAt(n);
            int n4 = n3;
            int n5 = 60;
            if (n == this.selectedAppIndex) {
                graphics.setColor(0xD3D3D3);
                graphics.fillRect(0, n4, this.width, n5);
            }
            graphics.setColor(15220566);
            graphics.setFont(Font.getFont((int)0, (int)1, (int)0));
            this.drawText(graphics, "#" + (n + 1), 10, n4 + n5 / 2, false);
            Image image = null;
            if (n < this.appIcons.size()) {
                image = (Image)this.appIcons.elementAt(n);
            }
            if (image != null) {
                graphics.drawImage(image, 25, n4 + n5 / 2, 6);
            } else {
                graphics.setColor(0xD3D3D3);
                graphics.fillRect(11, n4 + n5 / 2 - 16, 32, 32);
            }
            int n6 = 80;
            graphics.setColor(2899536);
            graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
            graphics.drawString(midletInfo.getName(), n6, n4 + 10, 20);
            graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
            String string = midletInfo.getDescription();
            if (string.length() > 40) {
                string = string.substring(0, 37) + "...";
            }
            graphics.drawString(string, n6, n4 + 30, 20);
            graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
            int n7 = midletInfo.getVotes();
            String string2 = String.valueOf(n7);
            if (n7 > 0) {
                string2 = "+" + string2;
                graphics.setColor(2600544);
            } else if (n7 < 0) {
                graphics.setColor(12597547);
            } else {
                graphics.setColor(8359053);
            }
            int n8 = this.width - 10 - 30;
            int n9 = n4 + n5 / 2;
            int n10 = graphics.getFont().stringWidth(string2) + 10;
            graphics.fillRoundRect(n8 - n10 / 2, n9 - 10, n10, 20, 6, 6);
            graphics.setColor(0xFFFFFF);
            graphics.drawString(string2, n8 - graphics.getFont().stringWidth(string2) / 2, n9 - graphics.getFont().getHeight() / 2, 20);
            graphics.setColor(0xD3D3D3);
            graphics.drawLine(0, n4 + n5, this.width, n4 + n5);
            n3 += n5;
        }
        this.contentHeight = n3 - n2;
        graphics.translate(0, this.scrollPosition);
        if (this.contentHeight > this.height - n2) {
            if (this.scrollPosition > 0) {
                graphics.setColor(8359053);
                n = this.width / 2;
                int n11 = n2 + 10;
                graphics.fillTriangle(n, n11, n - 10, n11 + 10, n + 10, n11 + 10);
            }
            if (this.scrollPosition < this.contentHeight - (this.height - n2)) {
                graphics.setColor(8359053);
                n = this.width / 2;
                int n12 = this.height - 10;
                graphics.fillTriangle(n, n12, n - 10, n12 - 10, n + 10, n12 - 10);
            }
        }
    }

    private void drawLoadingIndicator(Graphics graphics) {
        int n = 125;
        graphics.setColor(2899536);
        graphics.setFont(Font.getFont((int)0, (int)1, (int)0));
        this.drawCenteredText(graphics, "Loading Top Charts...", this.width / 2, n);
    }

    private void drawText(Graphics graphics, String string, int n, int n2, boolean bl) {
        int n3;
        if (bl) {
            n3 = graphics.getFont().stringWidth(string);
            n -= n3 / 2;
        }
        n3 = graphics.getFont().getHeight();
        graphics.drawString(string, n, n2 -= n3 / 2, 20);
    }

    private void drawCenteredText(Graphics graphics, String string, int n, int n2) {
        Font font = graphics.getFont();
        int n3 = font.stringWidth(string);
        int n4 = font.getHeight();
        graphics.drawString(string, n - n3 / 2, n2 - n4 / 2, 20);
    }

    protected void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        if (n >= 49 && n <= 57) {
            int n3 = n - 49;
            if (n3 < CATEGORIES.length) {
                this.selectedCategoryIndex = n3;
                this.loadCategoryApps(this.selectedCategoryIndex);
            }
        } else if (n == 48) {
            if (9 < CATEGORIES.length) {
                this.selectedCategoryIndex = 9;
                this.loadCategoryApps(this.selectedCategoryIndex);
            }
        } else if (n2 == 1) {
            if (this.selectedAppIndex > 0) {
                --this.selectedAppIndex;
                this.ensureSelectedVisible();
                this.repaint();
            } else if (this.selectedAppIndex == -1 && this.chartApps.size() > 0) {
                this.selectedAppIndex = 0;
                this.repaint();
            } else {
                this.scrollPosition = Math.max(0, this.scrollPosition - 20);
                this.repaint();
            }
        } else if (n2 == 6) {
            if (this.selectedAppIndex < this.chartApps.size() - 1) {
                ++this.selectedAppIndex;
                this.ensureSelectedVisible();
                this.repaint();
            } else {
                int n4 = Math.max(0, this.contentHeight - (this.height - 30 - 45));
                this.scrollPosition = Math.min(n4, this.scrollPosition + 20);
                this.repaint();
            }
        } else if (n2 == 8 && this.selectedAppIndex >= 0) {
            this.openSelectedApp();
        } else if (n2 == 2) {
            this.selectedCategoryIndex = (this.selectedCategoryIndex + CATEGORIES.length - 1) % CATEGORIES.length;
            this.loadCategoryApps(this.selectedCategoryIndex);
        } else if (n2 == 5) {
            this.selectedCategoryIndex = (this.selectedCategoryIndex + 1) % CATEGORIES.length;
            this.loadCategoryApps(this.selectedCategoryIndex);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.backCommand) {
            this.midletStore.showStoreCanvas();
        } else if (command == this.selectCommand && this.selectedAppIndex >= 0) {
            this.openSelectedApp();
        } else if (command == this.refreshCommand) {
            this.loadCategoryApps(this.selectedCategoryIndex);
        }
    }

    private void openSelectedApp() {
        if (this.selectedAppIndex >= 0 && this.selectedAppIndex < this.chartApps.size()) {
            MIDletStore.MidletInfo midletInfo = (MIDletStore.MidletInfo)this.chartApps.elementAt(this.selectedAppIndex);
            Image image = null;
            if (this.selectedAppIndex < this.appIcons.size()) {
                image = (Image)this.appIcons.elementAt(this.selectedAppIndex);
            }
            this.midletStore.showAppDetails(midletInfo, image);
        }
    }

    private void ensureSelectedVisible() {
        int n;
        if (this.selectedAppIndex < 0) {
            return;
        }
        int n2 = 85;
        int n3 = n2 + this.selectedAppIndex * 60;
        int n4 = n3 + 60;
        if (n3 - this.scrollPosition < n2) {
            this.scrollPosition = n3 - n2;
        } else if (n4 - this.scrollPosition > this.height) {
            this.scrollPosition = n4 - this.height;
        }
        if (this.scrollPosition < 0) {
            this.scrollPosition = 0;
        }
        if (this.scrollPosition > (n = Math.max(0, this.contentHeight - (this.height - 30 - 45)))) {
            this.scrollPosition = n;
        }
    }

    protected void pointerPressed(int n, int n2) {
        int n3;
        int n4;
        int n5;
        this.pointerPressed = true;
        this.lastPointerY = n2;
        if (!this.isLoading && this.chartApps.size() > 0 && (n5 = n2 + this.scrollPosition) >= (n4 = 85) && (n3 = (n5 - n4) / 60) >= 0 && n3 < this.chartApps.size()) {
            if (this.selectedAppIndex == n3) {
                this.openSelectedApp();
            } else {
                this.selectedAppIndex = n3;
                this.repaint();
            }
        }
    }

    protected void pointerDragged(int n, int n2) {
        int n3;
        int n4;
        if (!this.pointerPressed) {
            return;
        }
        int n5 = this.lastPointerY - n2;
        this.lastPointerY = n2;
        if (Math.abs(n5) < 2) {
            return;
        }
        this.scrollPosition += n5;
        if (this.scrollPosition < 0) {
            this.scrollPosition = 0;
        }
        if (this.scrollPosition > (n4 = Math.max(0, this.contentHeight - (this.height - (n3 = 75))))) {
            this.scrollPosition = n4;
        }
        this.repaint();
    }

    protected void pointerReleased(int n, int n2) {
        this.pointerPressed = false;
    }

    public void reset() {
        if (this.chartApps.size() == 0) {
            this.loadCategoryApps(this.selectedCategoryIndex);
        }
    }
}

