/*
 * Decompiled with CFR 0.152.
 */
package com.sun.svg.component;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class LoadingScreen
extends Canvas
implements Runnable {
    private static final int COLOR_BACKGROUND = 0xF0F0F0;
    private static final int COLOR_TEXT = 2719929;
    private static final int COLOR_SPINNER = 3447003;
    private String title;
    private String loadingText;
    private boolean animating;
    private Thread animationThread;
    private int spinnerPosition = 0;
    private int maxSpinnerPositions = 8;
    private Image loadingImage;

    public LoadingScreen() {
        this("Hack MIDlet Store", "Loading...");
    }

    public LoadingScreen(String string, String string2) {
        this.title = string;
        this.loadingText = string2;
        try {
            this.loadingImage = Image.createImage((String)"/loading_icon.png");
        }
        catch (Exception exception) {
            this.loadingImage = null;
        }
        this.startAnimation();
    }

    public void startAnimation() {
        if (!this.animating) {
            this.animating = true;
            this.animationThread = new Thread(this);
            this.animationThread.start();
        }
    }

    public void stopAnimation() {
        this.animating = false;
        if (this.animationThread != null) {
            this.animationThread = null;
        }
    }

    protected void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics.setColor(0xF0F0F0);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(2719929);
        graphics.setFont(Font.getFont((int)0, (int)1, (int)16));
        graphics.drawString(this.title, n / 2, n2 / 3, 65);
        graphics.setFont(Font.getFont((int)0, (int)0, (int)0));
        graphics.drawString(this.loadingText, n / 2, n2 / 2, 65);
        if (this.loadingImage != null) {
            graphics.drawImage(this.loadingImage, n / 2, n2 * 2 / 3, 3);
        } else {
            this.drawSpinner(graphics, n / 2, n2 * 2 / 3, 20);
        }
    }

    private void drawSpinner(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(3447003);
        for (int i = 0; i < this.maxSpinnerPositions; ++i) {
            int n4 = i == this.spinnerPosition ? 255 : 100 + 150 * i / this.maxSpinnerPositions;
            int n5 = i == this.spinnerPosition ? 5 : 3;
            double d = Math.PI * 2 * (double)i / (double)this.maxSpinnerPositions;
            int n6 = n + (int)(Math.cos(d) * (double)n3);
            int n7 = n2 + (int)(Math.sin(d) * (double)n3);
            graphics.fillArc(n6 - n5, n7 - n5, n5 * 2, n5 * 2, 0, 360);
        }
    }

    public void run() {
        try {
            while (this.animating) {
                this.spinnerPosition = (this.spinnerPosition + 1) % this.maxSpinnerPositions;
                this.repaint();
                Thread.sleep(150L);
            }
        }
        catch (InterruptedException interruptedException) {
            this.animating = false;
        }
    }

    protected void keyPressed(int n) {
    }

    protected void keyReleased(int n) {
    }
}

