/*
 * Decompiled with CFR 0.152.
 */
package com.sun.svg.util;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m2g.SVGAnimator;
import javax.microedition.m2g.SVGEventListener;
import javax.microedition.m2g.SVGImage;
import javax.microedition.m2g.ScalableGraphics;
import javax.microedition.m2g.ScalableImage;

public class DefaultSVGAnimator {
    public static SVGAnimator createAnimator(SVGImage sVGImage) {
        SVGAnimatorImpl sVGAnimatorImpl = new SVGAnimatorImpl(sVGImage);
        return sVGAnimatorImpl;
    }

    private static class SVGAnimatorCanvas
    extends Canvas
    implements Runnable {
        private SVGImage svgImage;
        private ScalableGraphics sg;
        private boolean animating = false;
        private Thread animationThread;
        private int width;
        private int height;

        public SVGAnimatorCanvas(SVGImage sVGImage) {
            this.svgImage = sVGImage;
            this.sg = ScalableGraphics.createInstance();
            this.startAnimating();
        }

        public void startAnimating() {
            if (!this.animating) {
                this.animating = true;
                this.animationThread = new Thread(this);
                this.animationThread.start();
            }
        }

        public void stopAnimating() {
            this.animating = false;
            if (this.animationThread != null) {
                this.animationThread = null;
            }
        }

        protected void paint(Graphics graphics) {
            this.width = this.getWidth();
            this.height = this.getHeight();
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 0, this.width, this.height);
            this.sg.bindTarget((Object)graphics);
            this.svgImage.setViewportWidth(this.width);
            this.svgImage.setViewportHeight(this.height);
            this.sg.render(0, 0, (ScalableImage)this.svgImage);
            this.sg.releaseTarget();
        }

        public void run() {
            try {
                while (this.animating) {
                    this.repaint();
                    Thread.sleep(50L);
                }
            }
            catch (InterruptedException interruptedException) {
                this.animating = false;
            }
        }

        protected void keyPressed(int n) {
        }

        protected void keyReleased(int n) {
        }
    }

    private static class SVGAnimatorImpl
    extends SVGAnimator {
        private SVGAnimatorCanvas canvas;
        private boolean started = false;

        public SVGAnimatorImpl(SVGImage sVGImage) {
            this.canvas = new SVGAnimatorCanvas(sVGImage);
        }

        public Object getTargetComponent() {
            return this.canvas;
        }

        public void play() {
            this.started = true;
            this.canvas.startAnimating();
        }

        public void stop() {
            this.started = false;
            this.canvas.stopAnimating();
        }

        public void pause() {
            if (this.started) {
                this.canvas.stopAnimating();
            }
        }

        public void setTimeMillis(long l) {
        }

        public void invokeLater(Runnable runnable) {
            new Thread(runnable).start();
        }

        public void invokeAndWait(Runnable runnable) {
            try {
                Thread thread = new Thread(runnable);
                thread.start();
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public float getTimeIncrement() {
            return 50.0f;
        }

        public void setTimeIncrement(float f) {
        }

        public void setSVGEventListener(SVGEventListener sVGEventListener) {
        }
    }
}

