/*
 * Decompiled with CFR 0.152.
 */
package tetris;

import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class MainMIDlet
extends MIDlet
implements CommandListener {
    private boolean midletPaused = false;
    private Command exitCommand;
    private TetrisCanvas canvas;
    private static final int YELLOW = 0xFFFF00;
    private static final int BLUE = 1456383;
    private static final int CYAN = 1828343;
    private static final int RED = 16135990;
    private static final int GREEN = 3144001;
    private static final int ORANGE = 16234045;
    private static final int PURPLE = 10889723;
    private static final int WHITE = 0xFFFFFF;
    private static final int BLACK = 0;
    private static final int[][][] TETROMINOS = new int[][][]{new int[][]{{1828343, 1828343, 1828343, 1828343}, {0, 0, 0, 0}}, new int[][]{{0, 0, 16234045}, {16234045, 16234045, 16234045}}, new int[][]{{1456383, 0, 0}, {1456383, 1456383, 1456383}}, new int[][]{{0, 3144001, 3144001}, {3144001, 3144001, 0}}, new int[][]{{16135990, 16135990, 0}, {0, 16135990, 16135990}}, new int[][]{{0xFFFF00, 0xFFFF00}, {0xFFFF00, 0xFFFF00}}, new int[][]{{0, 10889723, 0}, {10889723, 10889723, 10889723}}};
    private static final int WIDTH = 16;
    private static final int HEIGHT = 24;
    private static final Font TETRIS_FONT = Font.getFont((int)32, (int)1, (int)16);
    private static int ARENA_PANEL_HEIGHT;
    private static int ARENA_PANEL_WIDTH;
    private static int STATUS_PANEL_WIDTH;
    private static int ARENA_TOP;
    private static int PADDING;
    private static int BLOCK_SIZE;
    private Timer fallTimer;
    private static final int FALL_TIME = 1000;
    private Timer fastFallTimer;
    private static final int FAST_FALL_TIME = 100;
    private static int[][] grid;
    private int[][] currentTetromino = this.generateTetromino();
    private int currentTetrominoX = (16 - this.currentTetromino[0].length) / 2;
    private static int currentTetrominoY;
    private static int[][][] nextTetrominos;
    private static int score;

    private boolean canMoveDown(int[][] tetromino) {
        for (int i = 0; i < tetromino.length; ++i) {
            for (int j = 0; j < tetromino[i].length; ++j) {
                if (tetromino[i][j] == 0) continue;
                int newX = this.currentTetrominoX + j;
                int newY = currentTetrominoY + i + 1;
                if (newY < 24 && grid[newY][newX] == 0) continue;
                return false;
            }
        }
        return true;
    }

    private void fixTetromino() {
        for (int i = 0; i < this.currentTetromino.length; ++i) {
            for (int j = 0; j < this.currentTetromino[i].length; ++j) {
                if (this.currentTetromino[i][j] == 0) continue;
                MainMIDlet.grid[MainMIDlet.currentTetrominoY + i][this.currentTetrominoX + j] = this.currentTetromino[i][j];
            }
        }
    }

    private void clearRows() {
        int fullCount = 0;
        for (int i = 23; i >= 0; --i) {
            boolean full = true;
            for (int j = 0; j < 16; ++j) {
                if (grid[i][j] != 0) continue;
                full = false;
                break;
            }
            if (!full) continue;
            ++fullCount;
            for (int k = i; k > 0; --k) {
                System.arraycopy(grid[k - 1], 0, grid[k], 0, 16);
            }
            ++i;
        }
        switch (fullCount) {
            case 1: {
                score += 40;
                break;
            }
            case 2: {
                score += 100;
                break;
            }
            case 3: {
                score += 300;
                break;
            }
            case 4: {
                score += 1200;
                break;
            }
            default: {
                score += fullCount * fullCount * 100;
            }
        }
    }

    private void restartGame() {
        score = 0;
        this.initialize();
    }

    private void checkGameOver() {
        int tetrominoWidth = this.currentTetromino[0].length;
        for (int j = 0; j < tetrominoWidth; ++j) {
            int gridX = this.currentTetrominoX + j;
            if (this.currentTetromino[0][j] == 0 || grid[0][gridX] == 0) continue;
            this.switchDisplayable(null, (Displayable)new GameOverCanvas());
        }
    }

    private void moveTetrominoDown() {
        if (this.canMoveDown(this.currentTetromino)) {
            ++currentTetrominoY;
        } else {
            this.fixTetromino();
            this.clearRows();
            this.checkGameOver();
            this.currentTetromino = nextTetrominos[0];
            this.currentTetrominoX = (16 - this.currentTetromino[0].length) / 2;
            currentTetrominoY = 0;
            for (int i = 0; i < nextTetrominos.length - 1; ++i) {
                MainMIDlet.nextTetrominos[i] = nextTetrominos[i + 1];
            }
            MainMIDlet.nextTetrominos[MainMIDlet.nextTetrominos.length - 1] = this.generateTetromino();
        }
        this.canvas.repaint();
    }

    private void initialize() {
        int i;
        if (this.fallTimer != null) {
            this.fallTimer.cancel();
        }
        if (this.fastFallTimer != null) {
            this.fastFallTimer.cancel();
        }
        for (i = 0; i < 24; ++i) {
            for (int j = 0; j < 16; ++j) {
                MainMIDlet.grid[i][j] = 0;
            }
        }
        this.currentTetromino = this.generateTetromino();
        for (i = 0; i < nextTetrominos.length; ++i) {
            MainMIDlet.nextTetrominos[i] = this.generateTetromino();
        }
        this.fallTimer = new Timer();
        this.fallTimer.scheduleAtFixedRate(new TimerTask(){

            public void run() {
                MainMIDlet.this.moveTetrominoDown();
            }
        }, 1000L, 1000L);
        this.canvas = new TetrisCanvas();
        this.switchDisplayable(null, (Displayable)this.canvas);
    }

    public void startMIDlet() {
    }

    public void resumeMIDlet() {
    }

    public void switchDisplayable(Alert alert, Displayable nextDisplayable) {
        Display display = this.getDisplay();
        if (alert == null) {
            display.setCurrent(nextDisplayable);
        } else {
            display.setCurrent(alert, nextDisplayable);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.getExitCommand()) {
            this.exitMIDlet();
        }
    }

    public Command getExitCommand() {
        if (this.exitCommand == null) {
            this.exitCommand = new Command("Exit", 7, 0);
        }
        return this.exitCommand;
    }

    public Display getDisplay() {
        return Display.getDisplay((MIDlet)this);
    }

    public void exitMIDlet() {
        if (this.fallTimer != null) {
            this.fallTimer.cancel();
        }
        this.fastFallTimer.cancel();
        this.switchDisplayable(null, null);
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void startApp() {
        if (this.midletPaused) {
            this.resumeMIDlet();
        } else {
            this.initialize();
            this.startMIDlet();
        }
        this.midletPaused = false;
    }

    public void pauseApp() {
        this.midletPaused = true;
    }

    public void destroyApp(boolean unconditional) {
    }

    private int[][] generateTetromino() {
        int random1 = new Random().nextInt(TETROMINOS.length);
        int random2 = new Random().nextInt(TETROMINOS.length);
        for (int i = 0; i < 200 || random1 == random2; ++i) {
            random2 = new Random().nextInt(TETROMINOS.length);
        }
        return TETROMINOS[random2];
    }

    private int[][] rotateTetromino(int[][] tetromino) {
        int rows = tetromino.length;
        int cols = tetromino[0].length;
        int[][] rotatedTetromino = new int[cols][rows];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                rotatedTetromino[j][rows - 1 - i] = tetromino[i][j];
            }
        }
        return rotatedTetromino;
    }

    static /* synthetic */ int[][] access$1202(MainMIDlet x0, int[][] x1) {
        x0.currentTetromino = x1;
        return x1;
    }

    static {
        grid = new int[24][16];
        currentTetrominoY = ARENA_TOP;
        nextTetrominos = new int[4][][];
        score = 0;
    }

    private class TetrisCanvas
    extends Canvas {
        private TetrisCanvas() {
        }

        protected void paint(Graphics g) {
            int j;
            int i;
            PADDING = this.getWidth() / 16 / 2;
            STATUS_PANEL_WIDTH = this.getWidth() / 3;
            ARENA_PANEL_WIDTH = this.getWidth() - STATUS_PANEL_WIDTH;
            BLOCK_SIZE = ARENA_PANEL_WIDTH / 16;
            ARENA_PANEL_HEIGHT = 24 * BLOCK_SIZE;
            ARENA_TOP = (this.getHeight() - ARENA_PANEL_HEIGHT) / 2;
            g.setColor(0);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(0xFFFFFF);
            g.drawRect(PADDING - 1, ARENA_TOP - 1, ARENA_PANEL_WIDTH + 1, ARENA_PANEL_HEIGHT + 1);
            for (i = 0; i < 24; ++i) {
                for (j = 0; j < 16; ++j) {
                    g.setColor(grid[i][j]);
                    g.fillRect(PADDING + j * BLOCK_SIZE, i * BLOCK_SIZE + (this.getHeight() - ARENA_PANEL_HEIGHT) / 2, BLOCK_SIZE, BLOCK_SIZE);
                }
            }
            for (i = 0; i < MainMIDlet.this.currentTetromino.length; ++i) {
                for (j = 0; j < MainMIDlet.this.currentTetromino[i].length; ++j) {
                    if (MainMIDlet.this.currentTetromino[i][j] == 0) continue;
                    g.setColor(MainMIDlet.this.currentTetromino[i][j]);
                    g.fillRect(PADDING + (MainMIDlet.this.currentTetrominoX + j) * BLOCK_SIZE, (currentTetrominoY + i) * BLOCK_SIZE + (this.getHeight() - ARENA_PANEL_HEIGHT) / 2, BLOCK_SIZE, BLOCK_SIZE);
                }
            }
            int scorePadding = (BLOCK_SIZE * 3 * 3 + PADDING / 2) / 2 + PADDING * 2;
            g.setFont(TETRIS_FONT);
            g.setColor(0xFFFFFF);
            int scoreStringX = TETRIS_FONT.stringWidth("SCO") / 2 + ARENA_PANEL_WIDTH + PADDING * 2;
            g.drawString("SCORE", scoreStringX, ARENA_TOP, 20);
            int scoreNumberStringX = (STATUS_PANEL_WIDTH - TETRIS_FONT.stringWidth(score + "")) / 2 + ARENA_PANEL_WIDTH + PADDING;
            g.drawString(score + "", scoreNumberStringX, ARENA_TOP + PADDING * 4, 20);
            int nextStringX = TETRIS_FONT.stringWidth("NEXT") / 2 + ARENA_PANEL_WIDTH + PADDING * 2;
            g.drawString("NEXT", nextStringX, ARENA_TOP + scorePadding, 20);
            for (int i2 = 0; i2 < nextTetrominos.length; ++i2) {
                for (int j2 = 0; j2 < nextTetrominos[i2].length; ++j2) {
                    for (int k = 0; k < nextTetrominos[i2][j2].length; ++k) {
                        if (nextTetrominos[i2][j2][k] == 0) {
                            g.setColor(0);
                        } else {
                            g.setColor(nextTetrominos[i2][j2][k]);
                        }
                        int nextTetrominoBlockX = PADDING + ARENA_PANEL_WIDTH + PADDING + (STATUS_PANEL_WIDTH - BLOCK_SIZE * nextTetrominos[i2][j2].length) / 2 + BLOCK_SIZE * k - BLOCK_SIZE + BLOCK_SIZE / 4;
                        int nextTetrominoBlockY = ARENA_TOP + scorePadding + PADDING * 2 + PADDING * 2 + j2 * BLOCK_SIZE + i2 * BLOCK_SIZE * 3;
                        g.fillRect(nextTetrominoBlockX, nextTetrominoBlockY, BLOCK_SIZE, BLOCK_SIZE);
                    }
                }
            }
        }

        private boolean canMoveLeft() {
            for (int i = 0; i < MainMIDlet.this.currentTetromino.length; ++i) {
                for (int j = 0; j < MainMIDlet.this.currentTetromino[i].length; ++j) {
                    if (MainMIDlet.this.currentTetromino[i][j] == 0) continue;
                    int newX = MainMIDlet.this.currentTetrominoX + j - 1;
                    int newY = currentTetrominoY + i;
                    if (newX >= 0 && grid[newY][newX] == 0) continue;
                    return false;
                }
            }
            return true;
        }

        private boolean canMoveRight() {
            for (int i = 0; i < MainMIDlet.this.currentTetromino.length; ++i) {
                for (int j = 0; j < MainMIDlet.this.currentTetromino[i].length; ++j) {
                    if (MainMIDlet.this.currentTetromino[i][j] == 0) continue;
                    int newX = MainMIDlet.this.currentTetrominoX + j + 1;
                    int newY = currentTetrominoY + i;
                    if (newX < 16 && grid[newY][newX] == 0) continue;
                    return false;
                }
            }
            return true;
        }

        private void startFastDrop() {
            MainMIDlet.this.fastFallTimer = new Timer();
            MainMIDlet.this.fastFallTimer.scheduleAtFixedRate(new TimerTask(){

                public void run() {
                    MainMIDlet.this.moveTetrominoDown();
                }
            }, 0L, 100L);
        }

        private void stopFastDrop() {
            if (MainMIDlet.this.fastFallTimer != null) {
                MainMIDlet.this.fastFallTimer.cancel();
                MainMIDlet.this.fastFallTimer = null;
            }
        }

        protected void keyReleased(int keyCode) {
            int gameAction = this.getGameAction(keyCode);
            if (gameAction == 6) {
                this.stopFastDrop();
            }
        }

        private boolean canPlaceRotatedTetromino(int[][] tetromino) {
            for (int i = 0; i < tetromino.length; ++i) {
                for (int j = 0; j < tetromino[i].length; ++j) {
                    if (tetromino[i][j] == 0) continue;
                    int newX = MainMIDlet.this.currentTetrominoX + j;
                    int newY = currentTetrominoY + i;
                    if (newX >= 0 && newX < 16 && newY < 24 && grid[newY][newX] == 0) continue;
                    return false;
                }
            }
            return true;
        }

        protected void keyPressed(int keyCode) {
            int gameAction = this.getGameAction(keyCode);
            switch (gameAction) {
                case 2: {
                    if (!this.canMoveLeft()) break;
                    MainMIDlet.this.currentTetrominoX--;
                    break;
                }
                case 5: {
                    if (!this.canMoveRight()) break;
                    MainMIDlet.this.currentTetrominoX++;
                    break;
                }
                case 6: {
                    if (MainMIDlet.this.fastFallTimer != null) break;
                    this.startFastDrop();
                    break;
                }
                case 1: {
                    int[][] rotatedTetromino = MainMIDlet.this.rotateTetromino(MainMIDlet.this.currentTetromino);
                    if (!this.canPlaceRotatedTetromino(rotatedTetromino)) break;
                    MainMIDlet.access$1202(MainMIDlet.this, rotatedTetromino);
                    break;
                }
            }
            this.repaint();
        }
    }

    private class GameOverCanvas
    extends Canvas
    implements CommandListener {
        private Command restartCommand = new Command("Restart", 4, 1);
        private Command exitCommand;

        public GameOverCanvas() {
            this.addCommand(this.restartCommand);
            this.exitCommand = new Command("Exit", 7, 1);
            this.addCommand(this.exitCommand);
            this.setCommandListener(this);
        }

        protected void paint(Graphics g) {
            g.setColor(0);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(0xFFFFFF);
            g.setFont(TETRIS_FONT);
            g.drawString("GAME OVER", this.getWidth() / 2, this.getHeight() / 4, 17);
            g.drawString("SCORE", this.getWidth() / 2, this.getHeight() / 2, 17);
            g.drawString(score + "", this.getWidth() / 2, this.getHeight() / 2 + PADDING * 4, 20);
        }

        public void commandAction(Command command, Displayable displayable) {
            if (command == this.restartCommand) {
                MainMIDlet.this.restartGame();
            } else if (command == this.exitCommand) {
                MainMIDlet.this.exitMIDlet();
            }
        }
    }
}

